﻿ using System;
 
 delegate double DoCalculate(double num);
 
 class RocketCalculator
 {
     private DoCalculate[] calculations;
     private int calculationCounter;
     
     public RocketCalculator()
     {
         calculationCounter = 0;
         calculations = new DoCalculate[10];
     }
     
     public void AddCalculation(DoCalculate newCalculation)
     {
         calculations[calculationCounter] = newCalculation;
         calculationCounter++;
     }
      
     public double StartCalculation(double tempValue)
     {
         Console.WriteLine("Wartość początkowa: {0}", tempValue);   
         for (int i = 0; i < calculationCounter; i++)
         {
              tempValue = calculations[i](tempValue);       
         }
         return tempValue;
     }
 }
 
 class Math
 {
     public static DoCalculate DoMinusTwenty = new DoCalculate(MinusTwenty);
     public static DoCalculate DoTimesTwo = new DoCalculate(TimesTwo);
     public static DoCalculate DoPlusTen = new DoCalculate(PlusTen);
 
     public static double MinusTwenty(double number)
     {
         Console.WriteLine("Minus dwadzieścia");
         return number - 20;
     }
     
     public static double TimesTwo(double number)
     {
         Console.WriteLine("Razy dwa");
         return number * 2;
     }
 
     public static double PlusTen(double number)
     {
         Console.WriteLine("Plus dziesięć");
         return number + 10;
     }  
 }
 
 public class Tester
 {
     public static void Main()
     {
         double startValue;
         double endResult;
         string response;
         
         RocketCalculator calculator = new RocketCalculator();
         
         Console.Write("Podaj wartość początkową: ");
         startValue = Convert.ToDouble(Console.ReadLine());
         Console.WriteLine("Wybierz kolejność działań ");
         Console.WriteLine("poprzez poniższe opcje");
         Console.WriteLine("M)inus dwadzieścia");
         Console.WriteLine("R)azy dwa");
         Console.WriteLine("P)lus dziesięć");
         Console.WriteLine("Aby wykonać obliczenia, naciśnij C\n");
         
         do
         {
             response = Console.ReadLine().ToUpper();
             switch(response)
             {
                 case "M":
                     calculator.AddCalculation(Math.DoMinusTwenty);
                     Console.WriteLine("Dodano działanie minus dwadzieścia");
                 break;
                 case "R":
                     calculator.AddCalculation(Math.DoTimesTwo);
                     Console.WriteLine("Dodano działanie razy dwa");
                 break;
                 case "P":
                     calculator.AddCalculation(Math.DoPlusTen);
                     Console.WriteLine("Dodano działanie plus dziesięć");
                 break;
                 case "C":
                     endResult = calculator.StartCalculation(startValue);
                    Console.WriteLine("Wynik końcowy: {0}", endResult);
                 break; 
                 default:
                    Console.WriteLine("Niepoprawny wybór, spróbuj ponownie ");
                 break;
             }
         } while (response != "C");
     }
 }
