﻿ using System;
 
 public class LogarithmicException : System.ApplicationException
 {
     private uint errorNumber;
 
 
     public LogarithmicException() : base("Wyjątek logarytmu")
     {
         errorNumber = 1000; 
     }
 
 
     public LogarithmicException(string message, uint initErrorNumber) : base(message)
     {
         errorNumber = initErrorNumber;
     }
     
     public uint ErrorNumber
     {
         get
         {
             return errorNumber;
         }
     }
 }
 
class MyMath
 {
     public static double CalculateLog(double num)
     {
         try
         {
             if(num < 0.0)
             {
                 throw new LogarithmicException("Logarytmu liczby ujemnej"+" nie można obliczyć", 1001);
             }
             if(num == 0.0)
             {
                 throw new LogarithmicException("Logarytm zera jest nieskończony", 1002);
             }
             return Math.Log(num);
         }
         catch(LogarithmicException exObj)
         {
             Console.WriteLine("Komunikat: " + exObj.Message);
             Console.WriteLine("Numer błędu: " + exObj.ErrorNumber);
             throw new ArithmeticException("Nie można obliczyć logarytmu z tej liczby"); 
         }
     }
 }
 
 class Tester
 {
     public static void Main()
     {
         try
         {
             double number;
             double result;
 
             Console.Write("Oblicz logarytm podanej liczby: ");
             number = Convert.ToDouble(Console.ReadLine());
             result = MyMath.CalculateLog(number);
             Console.WriteLine("Wynik wynosi: {0}", result);
         }
         catch(ArithmeticException exObj)
         {
             Console.WriteLine(exObj.Message);
         }
     }
 }
