﻿ using System;
 
 public struct TimeSpan
 {
     private uint totalSeconds;
     private const uint SecondsInHour = 3600;
     private const uint SecondsInMinute = 60;
 
     public TimeSpan(uint initialSeconds)
     {
         totalSeconds = initialSeconds;
     }
     
     public uint Seconds
     {
         get
         {
             return totalSeconds;
         }
         
         set
         {
             totalSeconds = value;
         }
     }
     
     public override string ToString()
     {
         uint hours;
         uint minutes;
         uint seconds;
          
         hours = totalSeconds / SecondsInHour;
         minutes = (totalSeconds % SecondsInHour) / SecondsInMinute;
         seconds = (totalSeconds % SecondsInHour) % SecondsInMinute;
         
         return String.Format("{0} Godz {1} Min {2} Sek", 
             hours, minutes, seconds);
     }
 }
 
 class Tester
 {
     public static void Main()
     {
         TimeSpan myTime = new TimeSpan(43403);
         TimeSpan yourTime = new TimeSpan();
         
         Console.WriteLine("Moja godzina: " + myTime);
         Console.WriteLine("Czas początkowy: " + yourTime);
         yourTime.Seconds = 310;
         Console.WriteLine("Czas końcowy: " + yourTime);
     }
 }
