﻿ using System;
 using System.Collections;
 
 class Account
 {
     private decimal balance;
     private decimal interestRate;
     private string holderName;
 
     public Account(decimal initialBalance, decimal initialInterestRate, string initialHolderName)
     {
         balance = initialBalance;
         interestRate = initialInterestRate;
         holderName = initialHolderName;
         BankStatistician.AccountAdded(balance);
         Console.WriteLine("Otworzono nowe konto! Wszystkie informacje zostały dostarczone\n"); 
     }
 
     public Account(string initialHolderName)
     {
         balance = 0;
         interestRate = 0;
         holderName = initialHolderName;
         BankStatistician.AccountAdded(balance);
         Console.WriteLine("Otworzono nowe konto! Dostarczono tylko nazwę posiadacza\n"); 
     }
    
     public Account()
     {
         balance = 0;
         interestRate = 0;
         holderName = "Jeszcze nie podano";
         BankStatistician.AccountAdded(balance);
         Console.WriteLine("Otworzono nowe konto! Nie dostarczono żadnych informacji\n");    
     }
 
     public void SetBalance (decimal newBalance)
     {
         balance = newBalance;
     }
 
     public void SetInterestRate (decimal newInterestRate)
     {
         interestRate = newInterestRate;
     }
 
     public void PrintDetails()
     {
         Console.WriteLine("Posiadacz konta: " + holderName);
         Console.WriteLine("Stan: {0:C}", balance);
         Console.WriteLine("Stopa procentowa: {0:C}\n", interestRate);
     }
 }
 
 class BankStatistician
 {
     private static int accountsCreated;
     private static decimal totalOpeningBalance;
 
     public static void AccountAdded(decimal openingBalance)
     {
         accountsCreated++;
         totalOpeningBalance += openingBalance;
     }
     
     public static void PrintAccountStatistics ()
     {
         Console.WriteLine("Liczba utworzonych kont: {0}", accountsCreated);
         Console.WriteLine("Średni stan otwarcia konta: {0:N2}", ((accountsCreated == 0) ? 0 : (totalOpeningBalance / accountsCreated)));
     }
 }
 
  class Bank
 {
     private ArrayList accounts;
     
    public Bank()
     {
         Console.WriteLine("Gratulacje! Utworzono nowy bank");
         accounts = new ArrayList();
     }
     
     public void OpenNewAccount ()
     {
         int choice;
         decimal initialBalance;
         decimal initialInterestRate;
         string initialHolderName;
 
         Console.WriteLine("Wpisz liczbę odpowiadającą informacjom, które posiadasz");
         Console.WriteLine("1) Stan, stopa procentowa i nazwa posiadacza konta");
         Console.WriteLine("2) Tylko nazwa posiadacza konta");
         Console.WriteLine("3) Brak dostępnych informacji");
         choice = Convert.ToInt32(Console.ReadLine());
         switch (choice)
         {
            case 1:
                Console.Write("Podaj stan otwarcia konta: ");
                initialBalance = Convert.ToDecimal(Console.ReadLine());
                Console.Write("Podaj początkową stopę procentową: ");
                initialInterestRate = Convert.ToDecimal(Console.ReadLine());
                Console.Write("Podaj nazwę posiadacza konta: ");
                initialHolderName = Console.ReadLine();
                accounts.Add(new Account(initialBalance, initialInterestRate, initialHolderName));
                break;
             case 2:
                 Console.Write("Podaj nazwę posiadacza konta: ");
                 initialHolderName = Console.ReadLine();
                 accounts.Add(new Account(initialHolderName));
                 break;
             case 3:
                 accounts.Add(new Account());
                 break;
             default:
                 Console.WriteLine("Nieprawidłowe dane");
                 break;
         }
     }
    
     public void PrintCurrentAccounts ()
     {
         foreach (Account tempAccount in accounts)
         {
             tempAccount.PrintDetails();
         }
     }
 }     

 class BankTester
 {
     public static void Main()
     {
         string answer;
        
         Bank myBank = new Bank();
         Console.WriteLine("Czy chcesz otworzyć konto? T) - tak N) - nie");
         answer = Console.ReadLine().ToUpper();
         while (!(answer == "N"))
         {       
             myBank.OpenNewAccount();
             Console.WriteLine("Czy chcesz otworzyć inne konto? T) - tak N) - nie");
             answer = Console.ReadLine().ToUpper();
         }
         myBank.PrintCurrentAccounts();
         BankStatistician.PrintAccountStatistics();
     }
 } 
