﻿ using System;
 
 class Book
 {
   private string title;
   private uint numberOfPages;
   private double weight;
 
  public void SetAll(string title, uint numberOfPages, double weight)
   {
     this.title = title;
     this.numberOfPages = numberOfPages;
     this.weight = weight;
   }  
 
   public double GetWeight()
   {
     return weight;
   }
 
   public void PrintShippingCost()
   {
     Console.WriteLine("\nKoszt transportu \"{0}\": {1:C}", title, Dispatcher.ShippingCost(this));
   }
 
   public Book GetHeavierBook (Book aBook)
   {
     if (weight > aBook.GetWeight())
       return this;
     else
       return aBook; 
   }
 }
 
 class Dispatcher
 {
   public static decimal ShippingCost (Book bookToSend)
  {
     return 5m + (decimal)(bookToSend.GetWeight() * 3);
   }
 }
 
 class VirtualBookshop
 {
   public static void Main()
   {
     Book myBook = new Book();
     Book yourBook = new Book();
     Book heavierBook;
 
     myBook.SetAll("Blipozjanie: kultura i zwyczaje", 400, 2.3);
     Console.WriteLine("Koszt transportu: {0:C}", Dispatcher.ShippingCost (myBook));
     myBook.PrintShippingCost();
 
     yourBook.SetAll("Mówimy po bliposku w dwadzieścia dni", 610, 3.1);
     heavierBook = yourBook.GetHeavierBook(myBook);
     heavierBook.PrintShippingCost();
   }
 }
