﻿ using System;
 
 class SortingCompetition
 {
      // Porządkowanie elementów tablicy rosnąco    
     public static void BubbleSortAscending(int [] bubbles)
     {
         bool swapped = true;
         
         for (int i = 0; swapped; i++)
         {
             swapped = false;
             for (int j = 0; j < (bubbles.Length - (i + 1)); j++)
             {
                 if (bubbles[j] > bubbles[j + 1])
                 {
                     Swap(j, j + 1, bubbles);
                     swapped = true;
                 }    
             }
         }
     }  
        
      // Zamiana miejscami dwóch elementów tablicy
     public static void Swap(int first, int second, int [] arr)
     {
         int temp;
         
         temp = arr[first];
         arr[first] = arr[second];
         arr[second] = temp;
     }
     
      // Wydruk całej tablicy
     public static void PrintArray (int [] arr)
     {
         for (int i = 0; i < arr.Length; i++)
         {
             Console.Write("{0}, ", arr[i]);
         }
     }
     
     public static void Main()
     {
         int [] testScores = new int [1000];        
         DateTime sortStart;
         DateTime sortEnd;
         
         for (int i = 0; i < testScores.Length; i++)
         {
             testScores[i] = testScores.Length - i;
         }
 
         Console.WriteLine("Teraz mierzony jest czas sortowania bąbelkowego. Proszę czekać...");
         sortStart = DateTime.Now;
         BubbleSortAscending(testScores);
         sortEnd = DateTime.Now;
         Console.WriteLine("Czas (sek) sortowania bąbelkowego tablicy o długości {0}: {1}",
             testScores.Length, ((sortEnd - sortStart).Ticks/10000000));
         
         for (int i = 0; i < testScores.Length; i++)
         {
             testScores[i] = testScores.Length - i;
         }
 
         Console.WriteLine("\nTeraz mierzony jest czas wbudowanej metody sortowania" + " klasy System.Array.\nProszę czekać...");
         sortStart = DateTime.Now;
         Array.Sort(testScores);
         sortEnd = DateTime.Now;
         Console.WriteLine("Czas (sek) sortowania przez .NET tablicy o długości {0}: {1}",testScores.Length, ((sortEnd -sortStart).Ticks/10000000));
     }
 }
