﻿ using System;
  
 class Account
 {
     private decimal balance;
     private decimal currentInterestRate;
     private decimal totalInterestPaid;
          
     public Account()
     {
         balance = 0;
         currentInterestRate = 0;
         totalInterestPaid = 0;  
     } 
          
     public void SetInterestRate(decimal newInterestRate)
     {
         currentInterestRate = newInterestRate;
     }
      
     public decimal GetInterestRate()
     {
         return currentInterestRate;
     }
      
     public void UpdateInterest()
     {
         totalInterestPaid += balance * currentInterestRate;
         balance += balance * currentInterestRate;  
     }
       
     public void Withdraw (decimal amount)
     {
         balance -= amount;
     }
      
     public void Deposit (decimal amount)
     {
         balance += amount;
     }
       
     public decimal GetBalance()
     {
         return balance;
     }
      
     public decimal GetTotalInterestPaid()
     {
         return totalInterestPaid;
     }
 }
  
class Bank
 {
    private Account [] accounts;
       
     public Bank()
     {
         Console.WriteLine("Gratulacje! Utworzyłeś nowy bank");
         Console.Write("Proszę podać liczbę kont w banku: ");
         accounts = new Account[Convert.ToInt32(Console.ReadLine())];
         for (int i = 0; i < accounts.Length; i++)
         {
             accounts[i] = new Account();
        }
     }
 
     public void Deposit()
     {
         int accountNumber;
         decimal amount;
         Console.Write("Depozyt. Proszę podać numer konta: ");
         accountNumber = Convert.ToInt32(Console.ReadLine());
         Console.Write("Podaj kwotę do wpłaty: ");
         amount = Convert.ToDecimal(Console.ReadLine());
         accounts[accountNumber - 1].Deposit(amount);
         Console.WriteLine("Nowy stan konta {0}: {1:C}",
             accountNumber,accounts[accountNumber - 1].GetBalance());
     }
      
     public void Withdraw()
     {
         int accountNumber;
         decimal amount;
         Console.Write("Wypłata. Proszę podać numer konta: ");
         accountNumber = Convert.ToInt32(Console.ReadLine());
         Console.Write("Podaj kwotę do wypłaty: ");
         amount = Convert.ToDecimal(Console.ReadLine());
         accounts[accountNumber - 1].Withdraw(amount);
         Console.WriteLine("Nowy stan konta {0}: {1:C}",
         accountNumber,accounts[accountNumber - 1].GetBalance());
     }
      
     public void SetInterestRate()
     {
         int accountNumber;
         decimal newInterestRate;
         Console.Write("Ustalanie stopy procentowej. "+ "Proszę podać numer konta: ");
         accountNumber = Convert.ToInt32(Console.ReadLine());
         Console.Write("Podaj stopę procentową: ");
         newInterestRate = Convert.ToDecimal(Console.ReadLine());
         accounts[accountNumber - 1].SetInterestRate(newInterestRate);
     }
     public void PrintAllInterestRates()
     {
         Console.WriteLine("Stopy procentowe wszystkich kont:");
         for (int i = 0; i < accounts.Length; i++)
         {
             Console.WriteLine("Konto {0,-3}: {1,-10}", (i + 1), accounts[i].GetInterestRate());       
         }
     }
      
     public void PrintAllBalances()
     {
         Console.WriteLine("Stany wszystkich kont:");
         for (int i = 0; i < accounts.Length; i++)
         {
             Console.WriteLine("Account {0,-3}: {1,12:C}", (i + 1), accounts[i].GetBalance());
         }
     }
         
     public void PrintTotalInterestPaidAllAccounts()
     {
         Console.WriteLine("Całkowity przyrost z oprocentowania"+ " indywidualnego konta");
         for (int i = 0; i < accounts.Length; i++)
         {
             Console.WriteLine("Konto {0,-3}: {1,12:C}", (i + 1), accounts[i].GetTotalInterestPaid());
         }
     }
      
     public void UpdateInterestAllAccounts()
     {
         for (int i = 0; i < accounts.Length; i++)
         {
             Console.WriteLine("Odsetki dodane do konta"+ " numer {0,-3}: {1,12:C}",
                 (i + 1), accounts[i].GetBalance() * accounts[i].GetInterestRate());
             accounts[i].UpdateInterest();
         }
     }
 }
  
 class BankSimulation
 {
     private static Bank bigBucksBank;
      
     public static void Main()
     {
         string command;
                 
         bigBucksBank = new Bank();       
         do
         {
             PrintMenu();
             command = Console.ReadLine().ToUpper();
             switch (command)
             {
                 case "D":
                     bigBucksBank.Deposit();
                     break;
                 case "W":
                     bigBucksBank.Withdraw();
                     break;
                 case "S":
                     bigBucksBank.SetInterestRate();
                     break;
                 case "U":
                     bigBucksBank.UpdateInterestAllAccounts();
                     break;
                 case "R":
                     bigBucksBank.PrintAllBalances();
                     break;
                 case "T":
                    bigBucksBank.PrintTotalInterestPaidAllAccounts();
                     break;
                 case "O":
                     bigBucksBank.PrintAllInterestRates();
                     break;
                 case "K":
                     Console.WriteLine("Do widzenia!");
                     break;
                 default:
                     Console.WriteLine("Niewłaściwy wybór");
                     break;
             }
         } while (command != "K");
     }
         
     private static void PrintMenu()
     {
         Console.WriteLine("\nCo chcesz uczynić?\n" +
             "D)epozyt\n" +
             "W)ypłata\n" +
             "Ustalenie S)topy procentowej\n" +
             "U)aktualnienie wszystkich kont o odsetki \n" +
             "WydR)uk wszystkich stanów kont\n" +
             "CałkowiT)e kwoty przyrostu z oprocentowania drukowane dla"+" wszystkich kont\n" +
             "Stopy O)procentowania dla wszystkich kont\n" +  
             "K)oniec sesji\n" +
             "Uwaga: Pierwsze konto ma numer jeden");
     }
 }
