﻿ using System;
 
 class Elevator
 {
     private int currentFloorNumber;
     private int floorsTraveled;
     
     public Elevator()
     {
         currentFloorNumber = 0;
         floorsTraveled = 0; 
     }
     
     public void MoveToFloor(int toFloorNumber)
     {
       floorsTraveled += Math.Abs(currentFloorNumber - toFloorNumber);
       currentFloorNumber = toFloorNumber;    
     }
     
     public int GetFloorsTraveled()
     {
         return floorsTraveled;
     }
     
     public int GetCurrentFloorNumber()
     {
         return currentFloorNumber;
     }
 }
 
 class ElevatorArray
 {
     public static void Main()
     {
        Elevator [] elevators = new Elevator[10];
         for (int i = 0; i < elevators.Length; i++)
         {
             elevators[i] = new Elevator();
         }
         
         elevators[0].MoveToFloor(10);
         elevators[4].MoveToFloor(20);
         elevators[0].MoveToFloor(5);
         elevators[4].MoveToFloor(7);
         
         Console.WriteLine("Liczba przejechanych pięter "+ "i aktualne położenie każdej windy\n");
         Console.WriteLine("              Liczba pięter   Aktualne"+ " położenie");
         for (int i = 0; i < elevators.Length; i++)
         {
             Console.WriteLine("Winda "+ "{0,2}:       {1,4}               {2,4}", (i + 1), elevators[i].GetFloorsTraveled(),
                 elevators[i].GetCurrentFloorNumber());        
         }
     }
 }
