﻿ using System;
 
 // Klasa umożliwiająca konwersję z systemu o podstawie 10 na dowolny 
    // inny system liczbowy
 // o podstawie od 2 do 16.
 public class NumberSystemConverter
 {
     const string digits = "0123456789abcdef";
 
     public static void Main()
     {
         int decimalNumber;
         int baseNumber;
         string answer = "T";
 
         do
         {
             try
             {
                 Console.Write("Podaj liczbę dziesiętną: ");
                 decimalNumber = Int32.Parse(Console.ReadLine());
                 Console.Write("Podaj podstawę: ");
                 baseNumber = Int32.Parse(Console.ReadLine());
                 if (baseNumber < 2 || baseNumber > 16)
                 {
                     throw (new InvalidBaseNumberException("Niepoprawna " +"wartość podstawy"));
                 }
                 Console.Write("Wynik: ");
                 printBase(decimalNumber, baseNumber);
                 Console.WriteLine();
                 Console.Write("Kolejna konwersja? T(ak) N(ie) ");
                 answer = Console.ReadLine().ToUpper();
                 Console.WriteLine();
             }
 
             catch (InvalidBaseNumberException ex)
             {
                 Console.WriteLine("InvalidBaseNumberException: {0}", ex);
             }
 
             catch (Exception ex)
             {
                 Console.WriteLine("Wyjątek: {0}", ex);
             }
 
         } while (answer == "T");
         Console.WriteLine("Miłego dnia. Pa, pa!");
     }
 
     public static void printBase(int n, int nBase)
     {
         // Metoda rekurencyjna do wydrukowania n przy dowolnej podstawie
         // Przyjmuje bazę z zakresu 2 <= nBase <= 16
         if (n >= nBase)
             // Metoda wywołuje sama siebie,
                // tworząc tym samym metodę rekurencyjną.
             printBase(n / nBase, nBase);
         Console.Write(digits[n % nBase]);
     }
 }
 
 
 public class InvalidBaseNumberException : Exception
 {
     public InvalidBaseNumberException()
     {
     }
 
     public InvalidBaseNumberException(string message) : base(message)
     {
     }
 
     public override string ToString()
     {
         return "Podstawa ma ograniczenie do zakresu: 2 <= base <= 16";
     }
 }
