﻿ using System;

 /*
  * Minuta zegara Blipos ma 256 sekund, a
  * doba ma 65536 minut. Noc trwa 
  * 32768 minut i jest reprezentowana przez ujemne wartości minut.
  * Dzień trwa 32767 minut reprezentowanych przez dodatnie
  * wartości. Kiedy minuty równają się 0, nie ma ani dnia, ani nocy.
  * Zegar może chodzić do przodu, do tyłu, być regulowany,
  * przesuwać się szybko do przodu i szybko do tyłu.
  */

 class BliposClock
 {
     private byte seconds;
     private short minutes;
 
     public BliposClock()
     {
         seconds = 0;
         minutes = 0;
     }
 
     public void OneForward()
     {
         byte originalSeconds = seconds;

         seconds++;
         if(originalSeconds > seconds)
              // Nadmiar zmiennej seconds 
             minutes++;
     }

     public void OneBackward()
     {
         byte originalSeconds = seconds;

         seconds--;
         if (originalSeconds < seconds)
              // Niedomiar zmiennej seconds 
             minutes--;
     }

     public void FastForward()
     {
         byte originalSeconds = seconds;

         seconds = (byte)(seconds + 50);
         if (originalSeconds > seconds)
              // Nadmiar zmiennej seconds
             minutes++;
     }
 
     public void FastBackward()
     {
         byte originalSeconds = seconds;

         seconds = (byte)(seconds - 50);
         if (originalSeconds < seconds)
              // Niedomiar zmiennej seconds
             minutes--;
     }

     public void SetSeconds(byte sec)
     {
         seconds = sec;
      }

     public void SetMinutes(short min)
     {
         minutes = min;
     }

     public void ShowTime()
     {
         Console.WriteLine("Sek: " + seconds + " Min: " + minutes);
     }
 }

 class RunBliposClock
  {
     public static void Main()
     {
         string command;
 
         Console.WriteLine("Witamy w Zegarze Blipos. " +
             "256 sekund na minutę " +
             "65536 minut na dzień");
         BliposClock myClock = new BliposClock();
         Console.WriteLine("Proszę ustaw zegar");
         Console.Write("Podaj sekundy: ");
         myClock.SetSeconds(Convert.ToByte(Console.ReadLine()));
         Console.Write("Podaj minuty: ");
         myClock.SetMinutes(Convert.ToInt16(Console.ReadLine()));
         Console.WriteLine("Podaj (F) do przodu lub (B) wstecz " +
             "(A) dodaj 50 (D) odejmij 50 (T) zakończ");
         do
         {
             command = Console.ReadLine().ToUpper();
             if (command == "F")
                 myClock.OneForward();
             if (command == "B")
                 myClock.OneBackward();
             if(command == "A")
                 myClock.FastForward();
             if(command == "D")
                 myClock.FastBackward();
             myClock.ShowTime();
         } while (command != "T");
         Console.WriteLine("Dziekuję za korzystanie z zegara Blipos!");
     }
 } 
