﻿ using System;
 
 enum MoveRequestType {FastForward, SlowForward, Reverse};
 
 class MoveRequestEventArgs : EventArgs
 {
     private MoveRequestType request;
 
     public MoveRequestEventArgs(MoveRequestType initRequest) : base()
     {
         request = initRequest;
     }
     
     public MoveRequestType Request
     {
         get
         {
             return request;
         }
     }
 }
 
 class GameController
 {
     public delegate void MoveRequest(object sender, MoveRequestEventArgs e);
     
     public event MoveRequest OnMoveRequest;
     
     Car[] gameCars = new Car[10];
     string carName;
     int speedParam = 0;
     int carCounter = 0;
     int carNumber = 0;
     
     public void Run()
     {
         string answer;
         Console.WriteLine("Dokonaj wyboru z podanego menu: ");
         Console.WriteLine("A) Dodaj nowy samochód");
         Console.WriteLine("C) Zapisz zdarzenie");
         Console.WriteLine("U) Wypisz się z listy zdarzeń");
         Console.WriteLine("L) Wypisz samochody z danej gry");
         Console.WriteLine("F) Szybko do przodu");
         Console.WriteLine("S) Powoli do przodu");
         Console.WriteLine("R) Wstecz");
         Console.WriteLine("T) Zakończ");
 
         do
         {
             Console.WriteLine("Wybierz nową opcję:");
             answer = Console.ReadLine().ToUpper();
             
             switch(answer)
             {
                 case "A":
                     Console.Write("Podaj nazwę nowego samochodu: ");
                     carName = Console.ReadLine();
                     Console.Write("Podaj parametr prędkości nowego samochodu: ");
                     speedParam = Convert.ToInt32(Console.ReadLine());
                     gameCars[carCounter] = new Car(speedParam, carName);
                     carCounter++;
                 break;
                 case "C":
                     Console.Write("Podaj indeks w tablicy dotyczący samochodu,"+ " którego zdarzenie wpisujemy: ");
                     carNumber = Convert.ToInt32(Console.ReadLine());
                     gameCars[carNumber].Subscribe(this);
                 break;
                 case "U":
                     Console.Write("Podaj indeks w tablicy dotyczący samochodu,"+ " którego chcemy wypisać: ");
                     carNumber = Convert.ToInt32(Console.ReadLine());
                     gameCars[carNumber].Unsubscribe(this);
                 break;
                 case "L":
                     for(int i=0; i < carCounter; i++)
                     {
                         Console.WriteLine(gameCars[i]);
                     }
                 break;
                 case "F":
                     if (OnMoveRequest != null)
                         OnMoveRequest(this, new MoveRequestEventArgs(MoveRequestType.FastForward));
                 break;
                 case "S":
                     if (OnMoveRequest != null)
                         OnMoveRequest(this, new MoveRequestEventArgs(MoveRequestType.SlowForward));
                 break;
                 case "R":
                     if (OnMoveRequest != null)
                         OnMoveRequest(this, new MoveRequestEventArgs(MoveRequestType.Reverse));
                 break;
                 case "T":
                 break;
                 default:
                     Console.WriteLine("Niepoprawny wybór. Spróbuj ponownie");
                 break;
             }
         } while(answer != "T");
     }
 }
 
 class Car
 {
     private int distance;
     private int speedParam;
     private string name;
     
     public Car(int initSpeedParam, string initName)
     {
         speedParam = initSpeedParam;
         distance = 0;
         name = initName;
     }
     
     public void Subscribe(GameController controller)
     {
         controller.OnMoveRequest += new GameController.MoveRequest(MoveRequestHandler);
     }
     
     public void Unsubscribe(GameController controller)
     {
         controller.OnMoveRequest -= new GameController.MoveRequest(MoveRequestHandler);
     }
 
     public void MoveRequestHandler(object sender, MoveRequestEventArgs e)
     {
         switch (e.Request)
         {
             case MoveRequestType.SlowForward:
                 distance += speedParam;
                 Console.WriteLine("Nazwa samochodu: " + name + " Wolna jazda."+" Odległość: " + distance);
             break;
             case MoveRequestType.FastForward:
                 distance += speedParam * 2; 
                 Console.WriteLine("Nazwa samochodu: " + name + " Szybka jazda."+" Odległość: " + distance);
             break;
             case MoveRequestType.Reverse:
                 distance -= 5;
                 Console.WriteLine("Nazwa samochodu: " + name + " Jazda wstecz."+ " Odległość: " + distance);
             break;
         }
     }
     
     public override string ToString()
     {
         return name;   
     } 
 }
 
 class Tester
 {
     public static void Main()
     {
         GameController controller = new GameController();
         controller.Run();
     }
 }
