﻿ using System;
 
 class Tester
 {
     public static void Main()
     {
         try
         {
             double number;
             double result;
             
             Console.Write("Oblicz logarytm podanej liczby: ");
             number = Convert.ToDouble(Console.ReadLine());
             result = MyMath.CalculateLog(number);
             Console.WriteLine("Wynik wynosi: {0}", result);
         }
         catch(ArithmeticException exObj)
         {
             Console.WriteLine("Wewnątrz bloku catch Main");
             Console.WriteLine("Komunikat: " + exObj.Message);
             Console.WriteLine("Link do pomocy: " + exObj.HelpLink);
             Console.WriteLine("Ślad wywołania metody: " + exObj.StackTrace);
         }
     }
 }
 
 class MyMath
 {
     public static double CalculateLog(double num)
     {
         try
         {
             if(num < 0.0)
             {
                 throw new ArithmeticException("Logarytmu liczby ujemnej nie można obliczyć");
             }
             if(num == 0.0)
             {
                 ArithmeticException arithEx = new ArithmeticException("Logarytm zera ma wartość nieskończoną");
                 arithEx.HelpLink = "http://www.themathwizards@#$.com";
                 throw arithEx;
             }
             return Math.Log(num);
         }
         catch(ArithmeticException exObj)
         {
             Console.WriteLine("Wewnątrz bloku catch CalculateLog");
             throw exObj;
         }
     }
 }
