﻿ using System;
 
 public abstract class Shape
 {
     public abstract void DrawYourself();
 }
 
 public class Triangle : Shape
 {
     public override void DrawYourself()
     {
         Console.WriteLine("         *     ");
         Console.WriteLine("        * *    ");
         Console.WriteLine("       *   *   ");
         Console.WriteLine("      *     *  ");
         Console.WriteLine("     *_______* ");
     }
 }
 
 public class Circle : Shape
 {   
     public override void DrawYourself()
     {
         Console.WriteLine("        ***     ");
         Console.WriteLine("     *       *  ");
         Console.WriteLine("    *         * ");
         Console.WriteLine("    *         * ");
         Console.WriteLine("     *       *  ");
         Console.WriteLine("        ***     ");
     }
 }
 
 public class Rectangle : Shape
 {
     public override void DrawYourself()
     {
         Console.WriteLine(" ------------------ ");
         Console.WriteLine("|__________________|");
     }
 }
