﻿ using System;
 
 public interface IComparable
 {
     int CompareTo(IComparable comp);
 }
 
 public class TimeSpan : IComparable
 {
     private uint totalSeconds;
     
     public TimeSpan()
     {
         totalSeconds = 0;
     }
 
     public TimeSpan(uint initialSeconds)
     {
         totalSeconds = initialSeconds;
     }
     
     public uint Seconds
     {
         get
         {
             return totalSeconds;
         }
         
        set
         {
             totalSeconds = value;
         }
     }
                 
     public virtual int CompareTo(IComparable comp)
     {
         TimeSpan compareTime = (TimeSpan) comp;
         
         if(totalSeconds > compareTime.Seconds)
             return 1;
         else if(compareTime.Seconds == totalSeconds)
             return 0;
         else
             return -1;
     }
 }
 
 class Sorter
 {
      // Posortuj rosnąco porównywalne elementy tablicy    
     public static void BubbleSortAscending(IComparable [] bubbles)
     {
         bool swapped = true;
         
         for (int i = 0; swapped; i++)
         {
             swapped = false;
             for (int j = 0; j < (bubbles.Length - (i + 1)); j++)
             {
                 if (bubbles[j].CompareTo(bubbles[j + 1]) > 0)
                 {
                     Swap(j, j + 1, bubbles);
                     swapped = true;
                 }    
             }
         }
     }
    
      //Zamień dwa elementy tablicy
     public static void Swap(int first, int second, IComparable [] arr)
     {
         IComparable temp;
         
         temp = arr[first];
         arr[first] = arr[second];
         arr[second] = temp;
     }
 }
 
 class Tester
 {
     public static void Main()
     {       
         TimeSpan [] raceTimes = new TimeSpan[4];
          
         raceTimes[0] = new TimeSpan(153);
         raceTimes[1] = new TimeSpan(165);
         raceTimes[2] = new TimeSpan(108);
         raceTimes[3] = new TimeSpan(142);
        
         Sorter.BubbleSortAscending(raceTimes);
        
         Console.WriteLine("Lista posortowanych czasów:");      
         foreach (TimeSpan time in raceTimes) 
         {
             Console.WriteLine(time.Seconds);
         }   
     }
 }
