﻿ using System;
 
 public interface IComparable
 {
     int CompareTo(IComparable comp);
 }
 
 public class TimeSpan : IComparable
 {
     private uint totalSeconds;
     
     public TimeSpan()
     {
         totalSeconds = 0;
     }
 
     public TimeSpan(uint initialSeconds)
    {
         totalSeconds = initialSeconds;
     }
     
     public uint Seconds
     {
         get
         {
             return totalSeconds;
         }
         
         set
         {
             totalSeconds = value;
         }
     }
             
     public int CompareTo(IComparable comp)
     {
         TimeSpan compareTime = (TimeSpan) comp;
         
         if(totalSeconds > compareTime.Seconds)
             return 1;
         else if(compareTime.Seconds == totalSeconds)
             return 0;
         else
             return -1;
     }
}
 
 class Tester
 {
     public static void Main()
     {
         TimeSpan myTime = new TimeSpan(3450);
         TimeSpan worldRecord = new TimeSpan(1239);
         
         if(myTime.CompareTo(worldRecord) < 0)
             Console.WriteLine("Mam czas poniżej rekordu świata");
         else if(myTime.CompareTo(worldRecord) == 0)
             Console.WriteLine("Mam czas równy rekordowi świata ");
         else
             Console.WriteLine("Jechałem dłużej od rekordu świata");  
     }
 }
