﻿ using System;
 
 class ProductionList
 {
     private uint[] production = new uint[4];
     
     public virtual uint this [uint index]
     {
         get
         {
             return production[index];
         }
         
         set
         {
             production[index] = value;
         }
     }
 }
 
 class ProductionSeasonAdjust : ProductionList
 {
     public override uint this [uint index]
     {
         get
         {
             if(index < 2)
                return base[index] + 50;
             else
                 return base[index] - 30; 
         }
         
         set
         {
             base[index] = value;
         }
     }
 
     public uint TotalSeasonalAdjusted
     {
         get
         {
             uint tempTotal = 0;
 
             for(uint i = 0; i < 4; i++)
             {
                 tempTotal += this[i];
             }
             return tempTotal;
         }
     }
 }
 
 class Tester
 {
     public static void Main()
     {
         ProductionSeasonAdjust prodAdjust = new ProductionSeasonAdjust();
         
         prodAdjust[0] = 100;
         prodAdjust[1] = 300;
         prodAdjust[2] = 200;
         prodAdjust[3] = 500;
         Console.WriteLine("Produkcja w pierwszym kwartale: " +  prodAdjust[0]);
         Console.WriteLine("Produkcja we wszystkich kwartałach: " +  prodAdjust.TotalSeasonalAdjusted);
     }
 }
