﻿ using System;
 
 class BirthsList
 {
     private int[] births;
     private string[] birthsRegionNames;

     public BirthsList(params string[] regionNames)
     {
         birthsRegionNames = regionNames;
         births = new int[regionNames.Length];
         for (int i = 0; i < regionNames.Length; i++)
         {
             births[i] = 0;
         }
     }
      
     public int this [int index]
     {
         get
         {
             if (index >= 0 && index < births.Length)
             {
                 return births[index];
             }
            else
             {
               Console.WriteLine("Dostarczono nieprawidłowy indeks");
                 return -1;
             }
         }
         set
         {
             if (index >= 0 && index < births.Length)
             {
                 births[index] = value;
             }
             else
             {
                 Console.WriteLine("Dostarczono nieprawidłowy indeks");
             }
         }
     }
         
     public int this [string indexName]
     {
         get
         {   
             return this [NameToIndex(indexName)];
         }
         set
         {
             this[NameToIndex(indexName)] = value;
         }
     }
         
     private int NameToIndex(string indexName)
     {
         for (int i = 0; i < birthsRegionNames.Length; i++)
         {
             if (birthsRegionNames[i].ToUpper() == indexName.ToUpper())
                 return i;
         }
         Console.WriteLine("Nie można znaleźć nazwy regionu");
         return -1;
     }
     
     public int TotalBirths
     {
         get
         {
             int sum = 0;
             foreach (int amount in births)
             {
                 sum += amount;
             }
             return sum;
         }
     }
 
     public int Average
     {
         get
         {
             return TotalBirths / births.Length;
         } 
     }
 }
  
 class BirthListTester
 {
     public static void Main()
     {
        BirthsList birthsListUSA = new BirthsList("Kalifornia","Nowy Jork","Teksas");
          
         birthsListUSA["Kalifornia"] = 10200;
         birthsListUSA[1] = 20398;
         birthsListUSA[2] = 40938;
                   
        Console.WriteLine("Liczba urodzeń w Teksasie: {0}",birthsListUSA["Teksas"]);
         Console.WriteLine("Wszystkie urodzenia: {0}   Średnia urodzeń: {1}", 
             birthsListUSA.TotalBirths, birthsListUSA.Average);
     }
 }
