﻿ using System;
 
 class MyFile
 {
     private static string fileContent = "Pewnego razu piękna księżniczka ...";
     private const int accessKey = 321;
     private static int mobileKey = accessKey; 
     
     public static int Open (int accessorNumber)
    {
        if (mobileKey == accessKey)
        {
            mobileKey = 0;
            Console.WriteLine("Dostęp uzyskał akcesor numer: {0} ", accessorNumber);
             return accessKey;
        }
        else
         {
             Console.WriteLine("Plik zajęty! Próba uzyskania dostępu nie powiodła się");
            return 0;
         }
    }  
 
     public static void Close (int returnKey, int accessorNumber) 
     {
         if (accessKey == returnKey)
        {
            mobileKey = returnKey;
             Console.WriteLine("Udane zamknięcie pliku przez akcesor numer {0} ",
                 accessorNumber);
         }
         else
         {
             Console.WriteLine("Plik nie może być zamknięty, błędny klucz zwrotny");
         }
     }
    
     public static string Read (int readKey)
     {
         if (readKey == accessKey)
         {
             return fileContent;
         }
         else
         {
             Console.WriteLine("Odmowa dostępu! Dostarczono błędny klucz");
             return "";
         } 
     }
     
     public static bool IsOccupied ()
     {
         if (mobileKey == accessKey)
             return false;
         else
            return true;
     }
 
     public static void Reset ()
     {
         mobileKey = accessKey;
     }
 }
 
 class FileAccessor
 { 
     private bool fileAccessEstablished;
     private bool disposed;
     private int accessKey;
     private int number;
     private static int objectCounter = 0;
     
     public FileAccessor ()
     {
         objectCounter++;
         number = objectCounter;
        if (!MyFile.IsOccupied())
         {
             accessKey = MyFile.Open(number);
             fileAccessEstablished = true;
            disposed = false;
        }
         else
         {
             Console.WriteLine("Błąd! Akcesor {0}. nie może uzyskać dostępu do MyFile", number);
             fileAccessEstablished = false;
         }   
     }
     
     private void FreeState ()
     {
         if (!disposed)
        {
             MyFile.Close(accessKey, number);
             fileAccessEstablished = false;
             disposed = true;
         }
         else
         {
             Console.WriteLine("Błąd! Więcej niż jedna próba dyspozycji akcesora {0}.", number);
         }
     }
     
     public void Dispose ()
     {
         FreeState ();
         GC.SuppressFinalize(this);
     }
     
     public void PrintFileContent ()
     {
         if (!disposed)
         {
             if (fileAccessEstablished)
                 Console.WriteLine("Zawartość wydrukowana przez akcesor {0}.: {1}", number, MyFile.Read(accessKey));
             else
                 Console.WriteLine("Akcesor {0}. nie ma dostępu do MyFile", number);
        }
         else
         {
             Console.WriteLine("Dostęp niemożliwy. Akcesor {0}. już uzyskał dostęp", number);
         }
     }
 }

 class TestFileAccess
 {
    public static void Main()
     {
         FileAccessor accessor1;
         FileAccessor accessor2;
         FileAccessor accessor3;
         FileAccessor accessor4;
         FileAccessor accessor5;
         FileAccessor accessor6;
 
         accessor1 = new FileAccessor ();
         accessor1.PrintFileContent ();
         accessor1.Dispose();
         accessor1 = null;
         
         accessor2 = new FileAccessor ();
         accessor2.PrintFileContent ();
         
         accessor3 = new FileAccessor ();
         accessor3.PrintFileContent();
         
         accessor2.Dispose();
         accessor2 = null;
         accessor3 = null;
                 
         accessor4 = new FileAccessor ();
         accessor4.PrintFileContent ();
         accessor4 = null;
         
         accessor5 = new FileAccessor ();
         
         MyFile.Reset();
         accessor5 = null;
         
         accessor6 = new FileAccessor ();
         accessor6.PrintFileContent ();
         accessor6.Dispose();
         accessor6.Dispose();
         accessor6 = null;  
     }
 }
