﻿ using System;
 
 class Bacterium
 {
     private static int bacteriaCreated;
     private static int tempBacteriaDestructed;
     private static int totalBacteriaDestructed;
     private static bool showBacteriaDestructed;
     private static bool hasGCJustRun;
     
     private int number;             
     private string name;
     private string shape;
     private string growthMethod;
     private string group;
     
     public Bacterium ()
     {
         if (hasGCJustRun)
         {
           Console.WriteLine("Obiekty bakterii zniszczone podczas wykonywania GC: {0}", tempBacteriaDestructed);
           Console.WriteLine("Różnica między utworzonymi bakteriami " + "a zniszczonymi bakteriami {0}",(bacteriaCreated - totalBacteriaDestructed));
           Console.WriteLine("Wznowienie tworzenia bakterii od numeru {0}\n", bacteriaCreated);
           hasGCJustRun = false; 
         }
         
         bacteriaCreated++;
         number = bacteriaCreated;
         name = "Streptococcus";
         shape = "okrągła";
         growthMethod = "łańcuchy";
         group = "alfa";    
     }
 
     static Bacterium ()
     {
         bacteriaCreated = 0;
         tempBacteriaDestructed = 0;
         totalBacteriaDestructed = 0;
         showBacteriaDestructed = false;
         hasGCJustRun = false;
     }
     
     ~Bacterium()
     {
         if(!hasGCJustRun)
         {
             Console.WriteLine("Tworzenie czasowo wstrzymane " + "na bakterii o numerze {0} w celu wykonania zniszczenia",bacteriaCreated);
             hasGCJustRun = true;
             tempBacteriaDestructed = 0;
         }
         if (showBacteriaDestructed)
         {
             Console.WriteLine("Bakteria : {0} zniszczona", number);
         }
         tempBacteriaDestructed++;
         totalBacteriaDestructed++;
     } 
     
     public static void SetShowBacteriaDestructed (bool showIt)
     {
         showBacteriaDestructed = showIt;
     }
     
     public static int GetTotalBacteriaDestructed ()
     {
         return totalBacteriaDestructed; 
     }
     
     public static int GetTotalBacteriaCreated ()
     {
         return bacteriaCreated;
     }
 }
 
 class Body
 {
     public static void Main()
     {
         int bacteriaCreatedBeforeCollect;
         int maxBacteria;
         Bacterium newBacterium;
 
         Console.Write("Ile bakterii chcesz utworzyć? ");
         maxBacteria = Convert.ToInt32(Console.ReadLine());
         Console.Write("Podaj liczbę bakterii do utworzenia, " + "zanim zostanie uruchomiony GC: ");
         bacteriaCreatedBeforeCollect = Convert.ToInt32(Console.ReadLine());
         Console.Write("Czy chcesz zobaczyć każdy numer" + "bakterii po usunięciu? T) - tak N) - nie ");
         if (Console.ReadLine().ToUpper() == "T")
             Bacterium.SetShowBacteriaDestructed (true);
         else
             Bacterium.SetShowBacteriaDestructed (false);
         Console.WriteLine("\nTworzenie rozpoczęte\n");
        
         for (int i = 0; i < maxBacteria; i++)
         {
             newBacterium = new Bacterium();
             if (i == (bacteriaCreatedBeforeCollect - 1))
             {
                Console.WriteLine("Inicjalizacja wykonywania GC " + "po utworzeniu bakterii o numerze {0}",(i + 1));
                 GC.Collect();
             }
         }
         
         Console.WriteLine("\nTworzenie zatrzymane na bakterii o numerze {0}", Bacterium.GetTotalBacteriaCreated());
         Console.WriteLine("Całkowita liczba bakterii zniszczonych " + "w czasie wykonywania programu {0}", Bacterium.GetTotalBacteriaDestructed());
     }
 }
