﻿ using System;
 using System.Collections;
 
 class Account
 {
     public static uint totalAccountsCreated = 0;
 
     public Account()
     {
         totalAccountsCreated++;
     } 
 }
 
 class Bank
 {
     private ArrayList accounts;
 
     public Bank()
     {
         Console.WriteLine("Gratulacje! Utworzyłeś nowy bank");
         accounts = new ArrayList();
     }
 
     public void AddNewAccount()
     {
         accounts.Add(new Account());
         Console.WriteLine("Dodano nowe konto!");
         PrintStatistics();
     }
 
     public void RemoveFirstAccount()
     {
         if (accounts.Count > 0)
         {
             accounts.RemoveAt(0);
             Console.WriteLine("Konto usunięto!\n");
             PrintStatistics();
         }
         else
         {
             Console.WriteLine("Nie ma więcej kont");
         }
     }
 
     public void PrintStatistics()
     {
         Console.WriteLine("Aktualna liczba kont: " + accounts.Count + "\nLiczba utworzonych nowych kont: " + Account.totalAccountsCreated);
     } 
 }
 
 class DynamicBankSimulation
 {
     private static Bank bigBucksBank;
 
     public static void Main()
     {
         string command;
 
         bigBucksBank = new Bank(); 
         do
         {
             PrintMenu();
             command = Console.ReadLine().ToUpper();
             switch (command)
             {
                 case "N":
                     bigBucksBank.AddNewAccount();
                     break;
                case "K":
                     Console.WriteLine("Do widzenia!");
                     break;
                 case "U":
                    bigBucksBank.RemoveFirstAccount();
                     break;
                 case "R":
                     bigBucksBank.PrintStatistics();
                     break;
                 default:
                     Console.WriteLine("Niewłaściwy wybór");
                     break;
              }
           } while (command != "K");
     }
 
     private static void PrintMenu()
     {
         Console.WriteLine("\nCo chcesz uczynić?\n" +"N) Dodać nowe konto\n" +"U) Usunąć konto\n" +
         "R) Wydrukować statystyki\n" +"K) Koniec sesji\n");
     }
 }
