﻿ using System;
 
 class FindTheIslandGame 
 { 
     public static void Main()
     {
         NavigationSystem navigator;
         int numberOfRows = 0;
         int numberOfColumns = 0;      
         byte rowGuess = 0;
         byte columnGuess = 0; 
         string answer;
 
         do
         {
              // Pozwala użytkownikowi określić rozmiar mapy
             Console.WriteLine("Pierwszy wybór rozmiaru mapy: ");
             Console.Write("Podaj liczbę wierszy: ");
             numberOfRows = Convert.ToInt32(Console.ReadLine());
             Console.Write("Podaj liczbę kolumn: ");
             numberOfColumns = Convert.ToInt32(Console.ReadLine());
             navigator = new NavigationSystem(numberOfRows, numberOfColumns);
              
             Console.WriteLine("\nOto mapa oceanu:\n" + "Pod jedną z fal ukryto wyspę.\n" +"Czy możesz ją znaleźć?\n" + 
                 "Podaj przypuszczalne położenie "+ "poprzez podanie wiersza i kolumny\n" +
                 "Każde co drugie przypuszczenie jest oceniane w kierunku wschód-zachód\n" +
                 "Pozostałe przypuszczenia są oceniane w kierunku północ-południe\n" +
                 "E na mapie oznacza, że wyspa leży na wschód od tego miejsca\n"+ "W oznacza na zachód; N na północ, a S na południe\n" +
                 "R oznacza poprawny wiersz, lecz niepoprawną kolumnę\n" + "C oznacza poprawną kolumnę, lecz niepoprawny wiersz\n");
             navigator.PrintMap();    
             do
             {
                 Console.Write("\nPodaj wiersz: ");
                 rowGuess = Convert.ToByte(Console.ReadLine());
                 Console.Write("Podaj kolumnę: ");
                 columnGuess = Convert.ToByte(Console.ReadLine());
             } while (!navigator.EvaluateGuess(rowGuess, columnGuess));
             Console.WriteLine("\nGratulacje! Litera I oznacza wyspę");
             Console.WriteLine("Wyspę znaleziono w {0} krokach", navigator.GetNumberOfGuesses());
             Console.WriteLine("\nMasz ochotę na nową grę? T=tak N=nie");
             answer = Console.ReadLine().ToUpper();
         } while (answer == "T"); 
     }
 }

 class NavigationSystem
 {
     char [,] map;
     byte secretRow = 0;
     byte secretColumn = 0;
     int guessCounter = 0;
    
     public NavigationSystem(int rows, int columns)
     {
         map = new char [rows, columns];
          // Losowy wybór sekretnego położenia wyspy
         Random randomizer = new Random();
         secretRow = (byte)randomizer.Next(0, map.GetLength(0)-1);
         secretColumn = (byte)randomizer.Next(0, map.GetLength(1)-1);
          // Wypełnianie mapy znakiem ~ symbolizującym fale
         for (int i = 0; i < map.GetLength(0); i++)
         {
             for(int j = 0; j < map.GetLength(1); j++)
             map[i,j] = '~';
         }    
         guessCounter = 0;  
     }
         
     public void PrintMap()
     {
         byte count = 0;

         Console.Write("  ");
         for (int i = 0; i < map.GetLength(1); i++)
         {
             if (count == 10)
                 count = 0;
             Console.Write(count);
             count++;        
         }
         Console.WriteLine();   
         for (int j = 0; j < map.GetLength(0); j++)
         {
            Console.Write(j + ((j < 10) ? " " : ""));
             for(int i = 0; i < map.GetLength(1); i++)
             Console.Write(map[j,i]);
             Console.WriteLine();
         }
     }
     
     public bool EvaluateGuess (int rowGuess, int columnGuess)
     {
         bool islandFound = false;

        guessCounter++;
         // Jeśli nie odnaleziono wyspy, a guessCounter jest parzysty,
         // wówczas sprawdzenie przypuszczenia w kierunku Pn-Pd,
         // w przeciwnym wypadku sprawdzenie przypuszczenia w kierunku Wsch-Zach 
        if ((rowGuess == secretRow) && (columnGuess == secretColumn))
        {
            map[rowGuess, columnGuess] = 'I';
            islandFound = true;
        }   
        else if (guessCounter % 2 == 0)
        {
            if (rowGuess < secretRow)
                map[rowGuess, columnGuess] = 'S'; 
            else if (rowGuess > secretRow)
                map[rowGuess, columnGuess] = 'N';
            else
                map[rowGuess, columnGuess] = 'R';           
        }
        else
        {
            if (columnGuess < secretColumn)
                map[rowGuess, columnGuess] = 'E';
            else if (columnGuess > secretColumn)
                map[rowGuess, columnGuess] = 'W';
            else
                map[rowGuess, columnGuess] = 'C';
        }
        PrintMap();
        return islandFound;
    }
    
    public int GetNumberOfGuesses()
    {
        return guessCounter;
    }
}
