﻿ using System;
 
 class BinarySearcher
 {
      // Szukanie wartości klucza w tablicy arr
      // za pomocą algorytmu przeszukiwania binarnego.
     public static int BinarySearch (int key, int[] arr)
    {
         int low = 0;
         int high = arr.Length - 1;
         int middle;
         
         while (low <= high)
         {
             middle = (low + high) / 2;
             if (key > arr[middle])
                 low = middle + 1;
             else if (key < arr[middle])
                 high = middle - 1;
             else
                 return middle;
         }
         return -1;
     }
    
      // PrintArray jest użyta jedynie dla ilustracji kolejnych wyborów. 
      // Drukuje ona segmenty tablicy arr, rozpoczynając
      // od najmniejszego indeksu w górę do najwyższego indeksu.
      // Środkowy element jest oznaczony literką m.
     public static void PrintArray(int low, int middle, int high, int [] arr)
     {
         for (int i = 0; i <= high; i++)
         {
             if (i < low)
             {
                 Console.Write("    ");
             }
             else
             {
                 if (i == middle)
                     Console.Write("{0,2}m ", arr[i]);
                 else
                     Console.Write("{0,2}  ", arr[i]);
             }
         }
         Console.WriteLine();
     }
     
     public static void Main()
     {
         int searchKey;
         int searchResult;
         int [] testScores = {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38};
        
         do
         {
             Console.Write("Podaj wartość, którą chcesz znaleźć: ");
             searchKey = Convert.ToInt32(Console.ReadLine());
             searchResult = BinarySearch(searchKey, testScores);
             if (searchResult >= 0)
                 Console.WriteLine("Wartość znaleziona na pozycji: {0}\n", searchResult);
             else
                 Console.WriteLine("Nie znaleziono takiej wartości\n");
             Console.Write("Chcesz szukać jeszcze raz? T=Tak N=Nie ");
         } while (Console.ReadLine().ToUpper() == "T");
     }
 }
