#include <iostream>
#include <vector>
#include <cmath>

double f (unsigned int n)
{
    const int rozmiar = 100;

    static bool first = true;
    static std::vector<double> tab(rozmiar);
    if (first)
    {
        first = false;
        long double suma = 0.0;
        for (int k = 0; k < rozmiar; k++)
        {
            long double x = 2.0 * M_PI * k / rozmiar;
            x = std::pow(sin(x), 5);
            x = atan(x);
            x = cbrt(x);
            suma += x;
            tab[k] = suma;
        }
    }
    return tab[n % rozmiar];      // wykorzystujemy okresowo f
}

int main()
{
    for (int i = 1000000000; i < 1000000005; i++)
        std::cout << f(i) << " ";
}
