#include <fstream>
#include <iostream>
#include <cctype>
#include <string>
#include <ext/hash_map>          // <-- koniecznie "ext/..."!!!

struct MyHashFun
{
    size_t operator()(std::string const& s) const     // <-- koniecznie `const'!!!
    {
        size_t wynik = 0;
        for (unsigned ui = 0; ui < s.size(); ++ui)
            wynik = 5*wynik + s[ui];
        return wynik;
    }
};

typedef __gnu_cxx::hash_map<std::string, int, MyHashFun> SLOWNIK;

// dalej bez zmian...

std::string czytaj_slowo(std::istream &F)         // wczytuje kolejne sowo z F
{
   char c;
   while (F.get(c) && !isalpha(c) && isascii(c))
     continue;                                    // <-- pominicie nie-liter
   std::string wynik;
   if (!F)                                        // <-- koniec pliku? 
      return wynik;                               // <-- pusty napis
   wynik += tolower(c);
   while(F.get(c) && (isalpha(c) || !isascii(c)) )
      wynik += tolower(c);                        // <-- buduje wyraz z liter
   return wynik;
}

void print_info(std::ostream & F, SLOWNIK const& slownik, std::string const& s)
{
   SLOWNIK::const_iterator iter = slownik.find(s);
   if (iter == slownik.end())
      F << "Slowa \"" << s << "\" nie znaleziono\n";
   else
      F << "Slowo \"" << s << "\" wystepuje " << iter->second << " razy\n";
}

int main(int, char* argv[])
{
   std::ifstream F (argv[1]);
   if (!F)
      exit(1);

   std::cout << "czytam plik '" << argv[1] << "'..." << std::flush;

   SLOWNIK slownik;
   for (std::string s = czytaj_slowo(F); !s.empty(); s = czytaj_slowo(F))
      ++slownik[s];

   std::cout << "\nZnalazlem " << slownik.size() << " roznych slow\n";

   print_info(std::cout, slownik, "rafa");
   print_info(std::cout, slownik, "ogary");
   print_info(std::cout, slownik, "komputer");
}
