#include <cstdlib>
#include <ctime>
#include <algorithm>
#include <iostream>

int porownaj_C(const void* pm, const void * pn) { // funkcja w stylu C
    int m = abs(*(int*)pm),     n = abs(*(int*)pn);
    if (m < n )  return -1;
    if (m > n)   return 1;
    return 0;
}

struct porownaj_CPP_fun_obj      // klasa obiektw funkcyjnych
{
    bool operator()(int n, int m) const { return abs(n) < abs(m); }
};

inline bool porownaj_CPP_inline_fun(int n, int m)  // funkcja inline
{
    return abs(n) < abs(m);
}

void przygotuj(int tab[], int size, time_t seed = 1000)
{
    srand(seed);
    for(int i = 0; i < size; i++)
        tab[i] = rand() - RAND_MAX/2;
}

int main()
{
    const int N = 10000000;
    int* tab = new int[N];

    przygotuj(tab, N);
    clock_t c0 = clock();
    qsort(tab, N, sizeof(tab[0]), porownaj_C);
    double t0 = (clock() - c0)/double(CLOCKS_PER_SEC);

    przygotuj(tab, N);
    c0 = clock();
    std::sort(tab, tab + N, porownaj_CPP_fun_obj());
    double t1 = (clock() - c0)/double(CLOCKS_PER_SEC);

    przygotuj(tab, N);
    c0 = clock();
    std::sort(tab, tab + N, porownaj_CPP_inline_fun);
    double t2 = (clock() - c0)/double(CLOCKS_PER_SEC);
    std::cout << "qsort: " << t0 <<  ", obiekt funkcyjny: " << t1
              << ", funkcja inline: " << t2 << " sekund\n";
    delete [] tab;
}
