#include <cassert>

template<typename T, unsigned N>
class SWektor
{
    T _tab[N];
public:
    unsigned   size() const                     { return N; }
    T &        operator[](unsigned n)           { assert(n < N); return _tab[n]; }
    T const&   operator[](unsigned n) const     { assert(n < N); return _tab[n]; }
};

int main()
{
    SWektor<double, 10> v;                       // wektor 10 elementw typu double
    SWektor<double, 11> w;                       // wektor 11 elementw typu double

    for (unsigned u = 0; u < v.size(); ++u)
        v[u] = w[u] = u;
    w[10] = 0.0;
}
