#include <iostream>
#include <vector>
#include <cmath>

double suma(double (*f)(int), int n0, int n1, double & err)
{
    std::vector<long double> v(n1 - n0 + 1);   
    long double suma = 0.0;
    for (int i = n0; i <= n1; ++i)
    {
        suma += f(i);
        v[i-n0] = suma;    
    }
    while(v.size() > 2)
    {
        for(size_t i = 0; i + 1 < v.size(); ++i)
            v[i] = 0.5*(v[i] + v[i+1]);
        v.pop_back();
    }
    double wynik = 0.5*(v[0] + v[1]);
    err = std::abs(v[0] - wynik);
    return wynik;
}


double moje(int n)
{ 
    if (n & 1)
        return -1.0/log(n);
    else
        return 1.0/log(n);
}

double moje2(int n)
{
    if (n & 1)
        return 1.0/n;
    else
        return -1.0/n;
}


int main()
{
    double err;
    double s = suma(moje, 2, 50, err);
    std::cout.precision(16);
    std::cout << s << "\t+- " << err << "\n";
    std::cout << log(2) << "\n";
    system("pause");
}
