#include <iostream>
#include <vector>
#include <string>

// pair przechowuje 2 skadowe dowolnych typw
template<typename T1, typename T2>
struct pair
{
    T1 first;
    T2 second;

    pair(): first(), second() { }

    pair(const T1& a, const T2& b) : first(a), second(b) { }

    template<class U1, class U2>
        pair(const pair<U1, U2>& p) : first(p.first), second(p.second) { }
};
 

// szablon funkcji tworzcej obiekt klasy pair 
// na podstawie typw argumentw wywoania teje funkcji
template<typename T1, typename T2>
    inline pair<T1, T2>
    make_pair(T1 x, T2 y) { return pair<T1, T2>(x, y); } 


int main()
{ 
    std::vector<pair<int, std::string> > v(10);
    for (int i = 0; i < (int)v.size(); ++i)
        v[i] = make_pair(i, "\n");
}


/*
int main()
{ 
    std::vector<pair<int, std::string> > v(10);
    for (int i = 0; i < (int)v.size(); ++i)
        v[i] = pair<int, std::string> (i, "\n");
}
*/


