#include <iostream>

template<typename T>
class Wektor
{
    size_t const m_rozmiar;
    T*  const m_ptab;
    
public:
    Wektor(size_t n)
       : m_rozmiar(n), m_ptab(new T[n])  {  }
    ~Wektor()                   { delete [] m_ptab; }
    size_t     size() const     { return m_rozmiar; }
    T &        at(int n)        { return m_ptab[n]; }
    T const&   at(int n) const  { return m_ptab[n]; }
};

int main()
{
    Wektor<double> v(10);     // wektor 10 elementw typu double
    Wektor<int>    w(20);     // wektor 20 elementw typu int
    v.at(5) = w.at(5) = 1;
    std::cout << "v.size() = " << v.size() << "\n";
    std::cout << "w.size() = " << w.size() << "\n";
}
