#include <iostream>
#include <vector>

std::vector<double> operator+ (std::vector<double> const& v,
                               std::vector<double> const& w)
{
    std::vector<double> wynik(v.size());
    // Prymitywne zabezpieczenie na wypadek, gdyby rozmiary obu wektorw byy rne
    for (unsigned i = 0; i < v.size() and i < w.size(); ++i)
        wynik[i] = v[i] + w[i];
    return wynik;
}

std::vector<double> & operator+= (std::vector<double> & v,
                                  std::vector<double> const& w)
{
    // Prymitywne zabezpieczenie na wypadek, gdyby rozmiary obu wektorw byy rne
    for (unsigned i = 0; i < v.size() and i < w.size(); ++i)
        v[i] += w[i];
    return v;
}
                               
std::ostream & operator<< (std::ostream & F, std::vector<double> const& v)
{
    F << "(";
    if (!v.empty())
        F << v[0];
    for (unsigned i = 1; i < v.size(); ++i)
        F << ", " << v[i];
    F << ")";
    return F;
}

int main()
{   
    std::vector<double> v1(3);
    for (int i = 0; i < 3; ++i)
        v1[i] = i;                           // v1 = 0, 1, 2
       
    std::cout << "v1 = " << v1 << "\n";
    std::cout << "v1 + v1 = " << v1 + v1 << "\n";
    v1 += v1;
    std::cout << "Po operacji v1 += v1 wartosc v1 wynosi " << v1 << "\n";
    std::cout << "Teraz v1 + v1 = " << v1 + v1 << "\n";
}

