#include <iostream>
#include <vector>
#include <bitset>

int main()
{
    const int N = 10000000;            // tyle liczb zostanie przetworzonych
    std::vector<unsigned> primes;      // pusty kontener na liczby pierwsze
    std::bitset<N> b;                  // teraz wszystkie N bitw w "b" jest "false"
    
    int p = 2;                         // 2 jest najmniejsz liczb pierwsz
    while(p < N)                   
    {
        primes.push_back(p);           // odkadamy p w kontenerze
        for (int i = p + p; i < N; i += p)  
            b[i] = true;               // odhaczamy wszystkie liczby podzielne przez p
        while(++p < N && b[p] == true)
            continue;                  // szukamy kolejnej liczby pierwszej
    }  
    std::cout << "Istnieje " << primes.size() 
              << " liczb pierwszych mniejszych od " << N << "\n";                
}

//    std::vector<bool> b(N);
