/* Testowanie sygnaw */

#include <signal.h>
#include <stdio.h>

void handler(int sig);
void raise_sig(void);

int main(void)
{
  void (*orig_handler)(int);

  printf("Instalowanie obsugi dla sygnau %d\n", SIGINT);
  orig_handler = signal(SIGINT, handler);
  raise_sig();

  printf("Zmiana obsugi sygnau na SIG_IGN\n");
  signal(SIGINT, SIG_IGN);
  raise_sig();

  printf("Przywrcenie pierwotnej obsugi\n");
  signal(SIGINT, orig_handler);
  raise_sig();

  printf("Normalne zakoczenie programu\n");
  return 0;
}

void handler(int sig)
{
  printf("Wywoano obsug dla sygnau %d\n", sig);
}

void raise_sig(void)
{
  raise(SIGINT);
}
