/* Test funkcji konwersji liczbowych C89 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

#define CHK_VALID   printf("    %s           %s\n",         \
                           errno != ERANGE ? "Tak" : "Nie", \
                           *ptr == '\0' ? "Tak" : "Nie")

int main(int argc, char *argv[])
{
  char *ptr;

    if (argc != 2) {
      printf("Sposb uycia: tnumconv cig-znakw\n");
      exit(EXIT_FAILURE);
    }

  printf("Funkcja   Warto zwracana\n");
  printf("-------   ----------------\n");
  printf("atof      %g\n", atof(argv[1]));
  printf("atoi      %d\n", atoi(argv[1]));
  printf("atol      %ld\n\n", atol(argv[1]));

  printf("Funkcja   Wynik          Poprawnie?   "
         "Zuycie cigu?\n"
         "-------   ------------   ----------   "
         "--------------\n");
  
  errno = 0;
  printf("strtod     %-16g", strtod(argv[1], &ptr));
  CHK_VALID;

  errno = 0;
  printf("strtol     %-16ld", strtol(argv[1], &ptr, 10));
  CHK_VALID;

  errno = 0;
  printf("strtoul    %-16lu", strtoul(argv[1], &ptr, 10));
  CHK_VALID;

  return 0;
}
