/* Utrzymuje baz danych czci magazynowych (wersja tablicowa) */

#include <stdio.h>
#include "readline.h"

#define NAME_LEN 25
#define MAX_PARTS 100

struct part {
  int number;
  char name[NAME_LEN+1];
  int on_hand;
} inventory[MAX_PARTS];

int num_parts = 0;    /* liczba czci w bazie danych */

int find_part(int number);
void insert(void);
void search(void);
void update(void);
void print(void);

/************************************************************
 * main: Pyta uytkownika o kod operacji, a nastpnie       *
 *       wywouje funkcj realizujc operacj  tak dugo, *
 *       uytkownik wprowadzi polecenie 'q'. Dla            *
 *       niepoprawnych operacji wypisuje komunikat          *
 *       o bdzie.                                         *                             
 ************************************************************/
int main(void)
{
  char code;

  for (;;) {
    printf("Podaj kod operacij: ");
    scanf(" %c", &code);
    while (getchar() != '\n')   /* przeskoczenie do koca wiersza */
      ;
    switch (code) {
      case 'i': insert();
                break;
      case 's': search();
                break;
      case 'u': update();
                break;
      case 'p': print();
                break;
      case 'q': return 0;
      default: printf("Niepoprawna operacja\n");
    }
    printf("\n");
  }
}

/**********************************************************
 * find_part: Szuka w tablicy czci o podanym numerze    *
 * i zwraca indeks czci w tablicy albo -1, jeli czci *
 * nie znaleziono.                                        *
 **********************************************************/
int find_part(int number)
{
  int i;

  for (i = 0; i < num_parts; i++)
    if (inventory[i].number == number)
      return i;

  return -1;
}

/**********************************************************
 * insert: Pyta uytkownika o dane nowej czci i wstawia *
 *         je do bazy danych. Jeli wprowadzana cz ju *
 *         znajduje si w tablicy albo tablica jest       *
 *         pena, wypisuje komunikat i koczy dziaanie.  *
 **********************************************************/
void insert(void)
{
  int part_number;

  if (num_parts == MAX_PARTS) {
    printf("Baza danych przepeniona: nie mona "
           "dodawa czci.\n");
    return;
  }

  printf("Podaj numer katalogowy: ");
  scanf("%d", &part_number);
  if (find_part(part_number) >= 0) {
    printf("Ju obecny w bazie danych.\n");
    return;
  }

  inventory[num_parts].number = part_number;
  printf("Podaj nazw: ");
  read_line(inventory[num_parts].name, NAME_LEN);
  printf("Podaj stan magazynowy: ");
  scanf("%d", &inventory[num_parts].on_hand);
  num_parts++;
}

/**********************************************************
 * search: Pyta uytkownika o numer czci, a nastpnie   *
 *         wyszukuje cz w bazie danych. Jeli znajdzie,*
 *         wypisuje nazw i stan magazynowy; jeli nie,   *
 *         wypisuje komunikat o bdzie.                  *
 **********************************************************/
void search(void)
{
  int i, number;

  printf("Podaj numer katalogowy: ");
  scanf("%d", &number);
  i = find_part(number);
  if (i >= 0) {
    printf("Nazwa: %s\n", inventory[i].name);
    printf("Stan magazynowy: %d\n", inventory[i].on_hand);
  } else
    printf("Nie znaleziono.\n");
}

/**********************************************************
 * update: Pyta uytkownika o numer czci; jeli nie ma  *
 *         jej w bazie danych, wypisuje komunikat         *
 *         o bdzie, a jeli jest, pyta o zmian stanu   *
 *         magazynowego i aktualizuje baz danych.        *
 **********************************************************/
void update(void)
{
  int i, number, change;

  printf("Podaj numer katalogowy: ");
  scanf("%d", &number);
  i = find_part(number);
  if (i >= 0) {
    printf("Podaj zmian stanu magazynowego: ");
    scanf("%d", &change);
    inventory[i].on_hand += change;
  } else
    printf("Nie znaleziono.\n");
}

/**********************************************************
 * print: Wypisuje wykaz czci z bazy danych             *
 *        z wyszczeglnieniem numerw katalogowych, nazw  *
 *        i stanw magazynowych; czci s wypisywane     *
 *        w kolejnoci wprowadzania ich do bazy danych.   *
 **********************************************************/
void print(void)
{
  int i;

  printf("Numer katalogowy   Nazwa                      "
         "Stan magazynowy\n");
  for (i = 0; i < num_parts; i++)
    printf("%16d   %-25s  %15d\n", inventory[i].number,
           inventory[i].name, inventory[i].on_hand);
}
