/* Gra w zgadywanie losowanej liczby */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_NUMBER 100

/* zmienna zewntrzna */
int secret_number;

/* prototypy */
void initialize_number_generator(void);
void choose_new_secret_number(void);
void read_guesses(void);

int main(void)
{
  char command;

  printf("Odgadnij liczb z zakresu od 1 do %d.\n\n",
         MAX_NUMBER);
  initialize_number_generator();
  do {
    choose_new_secret_number();
    printf("Wylosowano now liczb.\n");
    read_guesses();
    printf("Jeszcze raz? (T/N) ");
    scanf(" %c", &command);
    printf("\n");
    } while (command == 't' || command == 'T');

    return 0;
}

/**********************************************************
 * initialize_number_generator: inicjalizuje generator    *
 *                              liczb losowych na bazie   *         
 *                              biecej godziny.         *
 **********************************************************/
void initialize_number_generator(void)
{
  srand((unsigned) time(NULL));
}

/**********************************************************
 * choose_new_secret_number: losuje liczb z zakresu      *
 *                           od 1 do MAX_NUMBER           *
 *                           i zachowuje j w zmiennej    *
 *                           secret_number.               *
 **********************************************************/
void choose_new_secret_number(void)
{
  secret_number = rand() % MAX_NUMBER + 1;
}

/**********************************************************
 * read_guesses: wczytuje kolejne typy uytkownika        *
 *               i okrela trafno, podpowiadajc,       *
 *               czy typ jest zbyt niski, czy moe zbyt   *
 *               wysoki; trafny typ kwituje komunikatem   *
 *               o wygranej i koczy dziaanie.           *
 **********************************************************/
void read_guesses(void)
{
  int guess, num_guesses = 0;

  for (;;) {
    num_guesses++;
    printf("Podaj typ: ");
    scanf("%d", &guess);
    if (guess == secret_number) {
      printf("Wygrana, w %d prbach!\n\n", num_guesses);
      return;
    } else if (guess < secret_number)
      printf("Mao; sprbuj ponownie.\n");
    else
      printf("Duo; sprbuj ponownie.\n");
  }
}
