/* Kopiowanie pliku */

#include <stdio.h>
#include <stdlib.h>

int main(int argc, char *argv[])
{
  FILE *source_fp, *dest_fp;
  int ch;

  if (argc != 3) {
    fprintf(stderr, "Sposb uycia: fcopy <plik-rdowy> " 
            "<plik-docelowy>\n");
    exit(EXIT_FAILURE);
  }
  if ((source_fp = fopen(argv[1], "rb")) == NULL) {
    fprintf(stderr, "Nie mona otworzy pliku %s\n", 
            argv[1]);
    exit(EXIT_FAILURE);
  }
  if ((dest_fp = fopen(argv[2], "wb")) == NULL) {
    fprintf(stderr, "Nie mona otworzy pliku %s\n", 
            argv[2]);
    fclose(source_fp);
    exit(EXIT_FAILURE);
  }

  while ((ch = getc(source_fp)) != EOF)
    putc(ch, dest_fp);

  fclose(source_fp);
  fclose(dest_fp);
  return 0;
}
