/* Losuje pojedyncze rozdanie kart */

#include <stdbool.h>    /* tylko w C99 */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_SUITS 4
#define NUM_RANKS 13

int main(void)
{
  bool in_hand[NUM_SUITS][NUM_RANKS] = {{false, }, };
  int num_cards, rank, suit;
  const char rank_code[] = {'2','3','4','5','6','7','8',
                            '9','t','j','q','k','a'};
  const char suit_code[] = {'c','d','h','s'};

  srand((unsigned) time(NULL));

  printf("Podaj liczb kart w rozdaniu: ");
  scanf("%d", &num_cards);

  printf("W rozdaniu:");
  while (num_cards > 0) {
    suit = rand() % NUM_SUITS; /* losowanie koloru */
    rank = rand() % NUM_RANKS; /* losowanie numeru */
    if (!in_hand[suit][rank]) {
      in_hand[suit][rank] = true;
      num_cards--;
      printf(" %c%c", rank_code[rank], suit_code[suit]);
    }
  }
  printf("\n");

  return 0;
}
Zwrmy uwag na inicjalizator tablicy in_hands:
bool in_hand[NUM_SUITS][NUM_RANKS] = {false};
