/* okrelanie odlegoci pomidzy miastami */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct city_info {
  char *city;
  int miles;
};

int compare_cities(const void *key_ptr, const void *element_ptr);

int main(void)
{
  char city_name[81];
  struct city_info *ptr;
  const struct city_info mileage[] =
    {{"Berlin", 3965},        {"Buenos Aires", 5297},
    {"Cape Town", 7764},      {"Caracas", 2132},
    {"Chicago", 713},         {"Hongkong", 8054},
    {"Honolulu", 4964},       {"Istambu", 4975},
    {"Kair", 5602},           {"Kalkuta", 7918},
    {"Lizbona", 3364},        {"Londyn", 3458},
    {"Los Angeles", 2451},    {"Manila", 8498},
    {"Meksyk", 2094},         {"Montreal", 320},
    {"Moskwa", 4665},         {"Pary", 3624},
    {"Rio de Janeiro", 4817}, {"Rzym", 4281},
    {"San Francisco", 2571},  {"Szanghaj", 7371},
    {"Sztokholm", 3924},      {"Sydney", 9933},
    {"Tokio", 6740},          {"Warszawa", 4344},
    {"Waszyngton", 205}};

  printf("Podaj miasto docelowe: ");
  scanf("%80[^\n]", city_name);
  ptr = bsearch(city_name, mileage,
                sizeof(mileage) / sizeof(mileage[0]),
                sizeof(mileage[0]), compare_cities);
  if (ptr != NULL)
    printf("Nowy Jork dzieli od miasta %s %d mil.\n",
           city_name, ptr->miles);
  else
    printf("%s - nie znaleziono.\n", city_name);

  return 0;
}

int compare_cities(const void *key_ptr,
                   const void *element_ptr)
{
  return strcmp((char *) key_ptr,
                ((struct city_info *) element_ptr)->city);
}
