/* Klasyfikuje rozdanie pokerowe */
#include <stdbool.h>    /* tylko w C99 */
#include <stdio.h>
#include <stdlib.h>

#define NUM_RANKS 13
#define NUM_SUITS 4
#define NUM_CARDS 5

/* zmienne zewntrzne */
int num_in_rank[NUM_RANKS];
int num_in_suit[NUM_SUITS];
bool straight, flush, four, three;
int pairs; /* moliwe wartoci to 0, 1 lub 2 */

/* prototypy */
void read_cards(void);
void analyze_hand(void);
void print_result(void);

/**********************************************************
 * main: wywouje w kko funkcje read_cards,             *
 * analyze_hand oraz print_result.                        *
 **********************************************************/
int main(void)
{
  for (;;) {
    read_cards();
    analyze_hand();
    print_result();
  }
}

/**********************************************************
 * read_cards: wczytuje symbole kart do zmiennych         *
 *             zewntrznych; wykrywa powtrzenia          *
 *             i niepoprawne symbole.                     *
 **********************************************************/
void read_cards(void)
{
  bool card_exists[NUM_RANKS][NUM_SUITS];
  char ch, rank_ch, suit_ch;
  int rank, suit;
  bool bad_card;
  int cards_read = 0;

  for (rank = 0; rank < NUM_RANKS; rank++) {
    num_in_rank[rank] = 0;
    for (suit = 0; suit < NUM_SUITS; suit++)
      card_exists[rank][suit] = false;
  }

  for (suit = 0; suit < NUM_SUITS; suit++)
    num_in_suit[suit] = 0;

  while (cards_read < NUM_CARDS) {
    bad_card = false;

    printf("Twoja karta: ");

    rank_ch = getchar();
    switch (rank_ch) {
      case '0':           exit(EXIT_SUCCESS);
      case '2':           rank = 0; break;
      case '3':           rank = 1; break;
      case '4':           rank = 2; break;
      case '5':           rank = 3; break;
      case '6':           rank = 4; break;
      case '7':           rank = 5; break;
      case '8':           rank = 6; break;
      case '9':           rank = 7; break;
      case 't': case 'T': rank = 8; break;
      case 'j': case 'J': rank = 9; break;
      case 'q': case 'Q': rank = 10; break;
      case 'k': case 'K': rank = 11; break;
      case 'a': case 'A': rank = 12; break;
      default:            bad_card = true;
    }

    suit_ch = getchar();
    switch (suit_ch) {
      case 'c': case 'C': suit = 0; break;
      case 'd': case 'D': suit = 1; break;
      case 'h': case 'H': suit = 2; break;
      case 's': case 'S': suit = 3; break;
      default:            bad_card = true;
    }

    while ((ch = getchar()) != '\n')
      if (ch != ' ') bad_card = true;

    if (bad_card)
      printf("Niepoprawna; odrzucam.\n");
    else if (card_exists[rank][suit])
      printf("Duplikat; odrzucam.\n");
    else {
      num_in_rank[rank]++;
      num_in_suit[suit]++;
      card_exists[rank][suit] = true;
      cards_read++;
    }
  }
}

/**********************************************************
 * analyze_hand: sprawdza, czy rozdanie zawiera kolor,    *
 *               strita, karet, trjk, par; okrela    *
 *               liczb par; wynik analizy zapisuje       *
 *               w zmiennych zewntrznych.                *
 **********************************************************/
void analyze_hand(void)
{
  int num_consec = 0;
  int rank, suit;

  straight = false;
  flush = false;
  four = false;
  three = false;
  pairs = 0;

  /* kolor? */
  for (suit = 0; suit < NUM_SUITS; suit++)
    if (num_in_suit[suit] == NUM_CARDS)
      flush = true;

  /* strit? */
  rank = 0;
  while (num_in_rank[rank] == 0) rank++;
  for (; rank < NUM_RANKS && num_in_rank[rank] > 0; rank++)
    num_consec++;
  if (num_consec == NUM_CARDS) {
    straight = true;
    return;
  }

  /* kareta, trjka, para/pary? */
  for (rank = 0; rank < NUM_RANKS; rank++) {
    if (num_in_rank[rank] == 4) four = true;
    if (num_in_rank[rank] == 3) three = true;
    if (num_in_rank[rank] == 2) pairs++;
  }
}

/**********************************************************
 * print_result: informuje uytkownika o wyniku analizy   *
 *               na podstawie zmiennych zewntrznych      *
 *               ustawianych przez analyze_hand.          *
 **********************************************************/
void print_result(void)
{
  if (straight && flush) printf("POKER");
  else if (four)         printf("KARETA");
  else if (three && pairs == 1) printf("FUL");
  else if (flush)        printf("KOLOR");
  else if (straight)     printf("STRIT");
  else if (three)        printf("TRJKA");
  else if (pairs == 2)   printf("DWIE PARY");
  else if (pairs == 1)   printf("PARA");
  else                   printf("KARTA");

  printf("\n\n");
}
