/* Utrzymuje baz danych czci magazynowych (wersja tablicowa). */

#include <stdio.h>
#include <stdlib.h>
#include "readline.h"

#define NAME_LEN 25

struct part {
  int number;
  char name[NAME_LEN+1];
  int on_hand;
  struct part *next;
};

struct part *inventory = NULL; /* wskanik do pierwszego wza listy */

struct part *find_part(int number);
void insert(void);
void search(void);
void update(void);
void print(void);

/**********************************************************
 * main: Pyta uytkownika o kod operacji, a nastpnie     *
 *       wywouje funkcj realizujc operacj  tak      *
 *       dugo, a uytkownik wprowadzi polecenie 'q'.    *
 *       Dla niepoprawnych operacji wypisuje komunikat    *
 *       o bdzie.                                       *
 **********************************************************/
int main(void)
{
  char code;

  for (;;) {
    printf("Podaj kod operacji: ");
    scanf(" %c", &code);
    while (getchar() != '\n')   /* przeskoczenie do koca wiersza */
      ;
    switch (code) {
      case 'i': insert();
                break;
      case 's': search();
                break;
      case 'u': update();
                break;
      case 'p': print();
                break;
      case 'q': return 0;
      default: printf("Niepoprawna operacja\n");
    }
    printf("\n");
  }
}

/**********************************************************
 * find_part: Szuka na licie czci o podanym numerze    *
 *            i zwraca wskanik do czci albo wskanik   *
 *            pusty, jeli nie znaleziono czci.         *
 **********************************************************/
struct part *find_part(int number)
{
  struct part *p;

  for (p = inventory;
       p != NULL && number > p->number;
       p = p->next)
    ;
  if (p != NULL && number == p->number)
    return p;
  return NULL;
}

/**********************************************************
 * insert: Pyta uytkownika o dane nowej czci i wstawia *
 *         je na list z zachowaniem uporzdkowania       *
 *         wedug numeru katalogowego czci. Jeli       *
 *         wprowadzana cz znajduje si na licie albo  *
 *         nie uda si przydzieli pamici dla nowego     *
 *         wza, funkcja wypisuje komunikat i koczy     *
 *         dziaanie.                                     *
 **********************************************************/
void insert(void)
{
  struct part *cur, *prev, *new_node;

  new_node = malloc(sizeof(struct part));
  if (new_node == NULL) {
    printf("Baza danych przepeniona: "
           "nie mona dodawa czci.\n");
    return;
  }

  printf("Podaj numer katalogowy: ");
  scanf("%d", &new_node->number);

  for (cur = inventory, prev = NULL;
       cur != NULL && new_node->number > cur->number;
       prev = cur, cur = cur->next)
    ;
  if (cur != NULL && new_node->number == cur->number) {
    printf("Ju obecny w bazie danych.\n");
    free(new_node);
    return;
  }

  printf("Podaj nazw: ");
  read_line(new_node->name, NAME_LEN);
  printf("Podaj stan magazynowy: ");
  scanf("%d", &new_node->on_hand);

  new_node->next = cur;
  if (prev == NULL)
    inventory = new_node;
  else
    prev->next = new_node;
}

/**********************************************************
 * search: Pyta uytkownika o numer czci, a nastpnie   *
 *         wyszukuje cz w bazie danych. Jeli znajdzie,*
 *         wypisuje nazw i stan magazynowy; jeli nie,   *
 *         wypisuje komunikat o bdzie.                  *
 **********************************************************/
void search(void)
{
  int number;
  struct part *p;

  printf("Podaj numer katalogowy: ");
  scanf("%d", &number);
  p = find_part(number);
  if (i != NULL) {
    printf("Nazwa: %s\n", p->name);
    printf("Stan magazynowy: %d\n", p->on_hand);
  } else
    printf("Nie znaleziono.\n");
}

/**********************************************************
 * update: Pyta uytkownika o numer czci; jeli nie ma  *
 *         jej w bazie danych, wypisuje komunikat         *
 *         o bdzie, a jeli jest, pyta o zmian stanu   *
 *         magazynowego i aktualizuje baz danych.        *
 **********************************************************/
void update(void)
{
  int number, change;
  struct part *p;

  printf("Podaj numer katalogowy: ");
  scanf("%d", &number);
  p = find_part(number);
  if (p != NULL) {
    printf("Podaj zmian stanu magazynowego: ");
    scanf("%d", &change);
    p->on_hand += change;
  } else
    printf("Nie znaleziono.\n");
}

/**********************************************************
 * print: Wypisuje wykaz czci z bazy danych             *
 *        z wyszczeglnieniem numerw katalogowych, nazw  *
 *        i stanw magazynowych; czci s wypisywane     *
 *        w kolejnoci numerw katalogowych.              *
 **********************************************************/
void print(void)
{
  struct part *p;

  printf("Numer katalogowy   Nazwa                      "
         "Stan magazynowy\n");
  for (p = inventory; p != NULL; p = p->next)
    printf("%16d   %-25s  %15d\n", p->number, p->name, p->on_hand);
}
