// Funkcja przesuwająca wartość typu unsigned int: w lewo, jeśli
// liczba miejsc jest dodatnia, i w prawo, jeśli jest ujemna


#include <stdio.h>

unsigned int  shift (unsigned int  value, int  n)
{
    if ( n > 0 )     // przesunięcie w lewo
        value <<= n;
    else             // przesunięcie w prawo
        value >>= -n;

    return value;
}

int main (void)
{
    unsigned int  w1 = 0177777u, w2 = 0444u;
    unsigned int  shift (unsigned int  value, int  n);

    printf ("%o\t%o\n", shift (w1, 5), w1 << 5);
    printf ("%o\t%o\n", shift (w1, -6), w1 >> 6);
    printf ("%o\t%o\n", shift (w2, 0), w2 >> 0);
    printf ("%o\n", shift (shift (w1, -3), 3));

    return 0;
}
