package examples.webservices.rpc.curmudgeonEJB;

import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;

/**
 * Note: This is largely taken from an example EJB found in the
 * BEA WebLogic examples distribution.
 *
 * This interface is the home interface for the WeatherBean.java,
 * which in WebLogic is implemented by the code-generated container
 * class WeatherBeanC. A home interface may support one or more create
 * methods, which must correspond to methods named "ejbCreate" in the EJBean.
 *
 * @author Frank Cohen 2002 for Java Web Services Unleashed, published by SAMS
 */
public interface CurmudgeonHome extends EJBHome {

  /**
   * This method corresponds to the ejbCreate method in the bean
   * "CurmudgeonBean.java".
   * The parameter sets of the two methods are identical. When the client calls
   * <code>CurmudgeonHome.create()</code>, the container
   * allocates an instance of the EJBean and calls <code>ejbCreate()</code>.
   *
   * @return                  The Curmudgeon's Answer to your quandry
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   * @exception               CreateException
   *                          if there is a problem creating the bean
   * @see                     examples.ejb.basic.statelessSession.WeatherBean
   */
  Curmudgeon create() throws CreateException, RemoteException;
}
