package examples.webservices.rpc.curmudgeonEJB;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.lang.Math;
import java.util.Random;

/**
 * Note: This is largely taken from an example EJB found in the
 * BEA WebLogic examples distribution.
 *
 * CurmudgeonBean is a stateless Session Bean. This bean illustrates:
 * <ul>
 * <li> No persistence of state between calls to the Session Bean
 * <li> Looking up values from the Environment
 * </ul>
 *
 * @author Frank Cohen 2002 for Java Web Services Unleashed, published by SAMS
 */
public class CurmudgeonBean implements SessionBean {

  private static final boolean VERBOSE = true;
  private SessionContext ctx;
  private int tradeLimit;
  private Random randy = new Random();

  private String opinions [] = {
      "Your quandry makes me think of the time I realized that I was a genius chucked into a world filled with idiots.",
      "And when did you come to this quandry?",
      "Just how hard could it be to accomplish your goal?",
      "Why bother with a quandry like that.",
      "If you had only listened to me the first time.",
      "I am strongly in favor of your ideas, with a few of my refinements.",
      "That has to be the dumbest thing I have heard today.",
      "Your quandry is just like something I experienced before, please buy my book.",
      "I knew a great lady named Betsy who would have been able to answer your quandry in no time.",
      "Yes, you know the answer to this yourself, now go and do it.",
      };
  
  // You might also consider using WebLogic's log service
  private void log(String s) {
    if (VERBOSE) System.out.println(s);
  }

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   *
   */
  public void ejbActivate() {
    log("ejbActivate called");
  }

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   *
   */
  public void ejbRemove() {
    log("ejbRemove called");
  }

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   *
   */
  public void ejbPassivate() {
    log("ejbPassivate called");
  }

  /**
   * Sets the session context.
   *
   * @param ctx               SessionContext Context for session
   */
  public void setSessionContext(SessionContext ctx) {
    log("setSessionContext called");
    this.ctx = ctx;
  }

  /**
   * This method corresponds to the create method in the home interface
   * "CurmudgeonHome.java".
   * The parameter sets of the two methods are identical. When the client calls
   * <code>CurmudgeonHome.create()</code>, the container allocates an instance of
   * the EJBean and calls <code>ejbCreate()</code>.
   *
   * @exception               javax.ejb.CreateException if there is
   *                          a communications or systems failure
   * @see                     examples.ejb.basic.statelessSession.Weather
   */
  public void ejbCreate () throws CreateException {
    log("ejbCreate called");

    try {
      InitialContext ic = new InitialContext();
    } catch (NamingException ne) {
      throw new CreateException("Failed to find environment value "+ne);
    }
  }

  /**
   * Asks the curmudgeon for an opinion on the quandry provided.
   *
   * @param quandry           String quandry can be anything at all, the curmudgeon will have an opinion
   * @return                  String opinion
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   */
  public String getCurmudgeonOpinion(String quandry) {
    log("getCurmudgeonOpinion called");

    if ( quandry.toLowerCase().indexOf( "chocolate" ) >1 )
    {
        return "Anything with chocolate can't be entirely bad.";
    }
    
    return opinions[ randy.nextInt() % 9 ];
    
  }

}
