<%@ page errorPage="error.jsp" import="com.ibm.dynademo.*" %>
<jsp:useBean id="lister" scope="request" 
  class="com.ibm.dynademo.TemperatureLister" />

<%

String xmethods = request.getParameter("xmethods");
boolean local = xmethods == null;
String CHECKED = local ? "" : "CHECKED";

String city = request.getParameter("city");
if (city == null) {
	 city = "New York";
}

lister.setLocal(local);
TemperatureListing listing = lister.forCity(city);

%>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<html>
<head>
<meta http-equiv="Content-Type" 
  content="text/html; charset=iso-8859-1">
<meta name="GENERATOR" 
  content="Mozilla/4.73 [en] (Windows NT 5.0; U) [Netscape]">
<meta name="Author" content="Arthur Ryman">
<LINK REL="STYLESHEET" HREF="dynademo.css" TYPE="text/css">
<TITLE>Weather Application</TITLE>
</HEAD>
<BODY>
<h1>Weather Application</h1>
Check the <b>XMethods</b> check box to use the remote 
XMethods Temperature Web Service.
Enter the name of a city and click the <b>Go</b> 
button to get the Fahrenheit
and Celsius temperature
readings for the zip codes that belong to the city.
<FORM>
<TABLE>
<TR>
<TD>XMethods:</TD>
<TD WIDTH="10"></TD>
<TD><INPUT TYPE="CHECKBOX" 
  NAME="xmethods" VALUE="on" <%=CHECKED%>></TD>
</TR>
<TR>
<TD>City:</TD>
<TD WIDTH="10"></TD>
<TD><INPUT TYPE="TEXT" 
  NAME="city" VALUE="<%=city%>" SIZE=16></TD>
<TD WIDTH="10"></TD>
<TD><INPUT TYPE="SUBMIT" VALUE="Go"></TD>
</TR>
</TABLE>
</FORM>

<% if (listing.isError()) { %>
<P>The following error occurred: 
<%=listing.getErrorMessage()%>. 
Try another city.</P>
<% } else {

	TemperatureReading[] readings = listing.getReadings();
	if (readings.length == 0) { %>

<P>No readings where found for <%=city%>. 
Try another city.</P>

<%	} else { %>

<TABLE BORDER="1" 
  CELLSPACING="0" CELLPADDING="4" BGCOLOR="#FFFF00">

<TR BGCOLOR="#CCCCCC">
<TH>City</TH>
<TH>Zip</TH>
<TH>F</TH>
<TH>C</TH>
<TH>Date</TH>
</TR>

<% for (int i = 0; i < readings.length; i++) {

  TemperatureReading reading = readings[i]; %>

<TR>
<TD><%=reading.getCity()%></TD>
<TD><%=reading.getZipCode()%></TD>
<TD><%=reading.getFahrenheit()%></TD>
<TD><%=reading.getCelsius()%></TD>
<TD><%=reading.getDate()%></TD>
</TR>

<% } %>

</TABLE>

<% }
} %>
</BODY>
</HTML>
