import java.util.*;
import java.io.*;
import java.net.*;
import jwsunleashed.trading.ejb.TradeResult;
import jwsunleashed.trading.TradingException;

import org.apache.soap.*;
import org.apache.soap.encoding.*;
import org.apache.soap.encoding.soapenc.*;
import org.apache.soap.rpc.*;
import org.apache.soap.util.xml.*;

public class StockClient
{
    public static void main(String[] args)
    {
        try
        {
            URL url = new URL("http://localhost:8000/soap/servlet/rpcrouter");

// Create a new call for logging in
            Call call = new Call();
            call.setTargetObjectURI("urn:Trading");
            call.setMethodName("login");
            call.setEncodingStyleURI(Constants.NS_URI_SOAP_ENC);

// Create the list of parameters
            Vector params = new Vector();

            params.addElement(new Parameter("userID", String.class,
                "mark", null));
            params.addElement(new Parameter("password", String.class,
                "secret", null));

            call.setParams(params);

// Invoke the call
            Response resp = call.invoke(url, "");

            String uniqueID = null;

            if (!resp.generatedFault())
            {
                Parameter ret = resp.getReturnValue();

                uniqueID = (String) ret.getValue();

                System.out.println("Your login ID is: "+uniqueID);
            }
            else
            {
                Fault fault = resp.getFault();
                System.err.println("Generated fault:");
                System.err.println("  Fault code    = " + fault.getFaultCode());
                System.err.println("  Fault string  = " + fault.getFaultString());
                System.exit(0);
            }

// For the other calls, you need a BeanSerializer to process the
// TradeResult objects
            BeanSerializer ser = new BeanSerializer();

            SOAPMappingRegistry reg = new SOAPMappingRegistry();

            reg.mapTypes(Constants.NS_URI_SOAP_ENC,
                new QName("urn:stocktrading", "traderesult"),
                    TradeResult.class, ser, ser);

// Create another call for issuing a put order
            call = new Call();

            call.setTargetObjectURI("urn:Trading");
            call.setMethodName("put");
            call.setEncodingStyleURI(Constants.NS_URI_SOAP_ENC);

// Tell the call how to deserialize a TradeResult
            call.setSOAPMappingRegistry(reg);

// Create the parameter list
            params = new Vector();

            params.addElement(new Parameter("uniqueID", String.class,
                uniqueID, null));
            params.addElement(new Parameter("stock", String.class,
                "SUNW", null));
            params.addElement(new Parameter("shares", Integer.class,
                new Integer(1000), null));
            params.addElement(new Parameter("price", Integer.class,
                new Integer(2000), null));

            call.setParams(params);

// Invoke the call
            resp = call.invoke(url, "");

            if (!resp.generatedFault())
            {
                Parameter ret = resp.getReturnValue();

                TradeResult result = (TradeResult) ret.getValue();

                System.out.println(result);
            }
            else
            {
                Fault fault = resp.getFault();
                System.err.println("Generated fault:");
                System.err.println("  Fault code    = " + fault.getFaultCode());
                System.err.println("  Fault string  = " + fault.getFaultString());
                System.exit(0);
            }

// Create a call for issuing a buy order
            call = new Call();
            call.setTargetObjectURI("urn:Trading");
            call.setMethodName("buy");
            call.setEncodingStyleURI(Constants.NS_URI_SOAP_ENC);

// Tell the call how to deserialize a TradeResult
            call.setSOAPMappingRegistry(reg);

// Create the parameter list
            params = new Vector();

            params.addElement(new Parameter("uniqueID", String.class,
                uniqueID, null));
            params.addElement(new Parameter("stock", String.class,
                "SUNW", null));
            params.addElement(new Parameter("shares", Integer.class,
                new Integer(1000), null));
            params.addElement(new Parameter("price", Integer.class,
                new Integer(2200), null));

            call.setParams(params);

// Invoke the call
            resp = call.invoke(url, "");

            if (!resp.generatedFault())
            {
                Parameter ret = resp.getReturnValue();

                TradeResult result = (TradeResult) ret.getValue();

                System.out.println(result);
            }
            else
            {
                Fault fault = resp.getFault();
                System.err.println("Generated fault:");
                System.err.println("  Fault code    = " + fault.getFaultCode());
                System.err.println("  Fault string  = " + fault.getFaultString());
                System.exit(0);
            }

// Create a call for logging out
            call = new Call();
            call.setTargetObjectURI("urn:Trading");
            call.setMethodName("logout");
            call.setEncodingStyleURI(Constants.NS_URI_SOAP_ENC);

// Create the parameter list
            params = new Vector();

            params.addElement(new Parameter("uniqueID", String.class,
                uniqueID, null));

            call.setParams(params);

// Invoke the call
            resp = call.invoke(url, "");

            if (!resp.generatedFault())
            {
                System.out.println("You have logged out successfully.");
            }
            else
            {
                Fault fault = resp.getFault();
                System.err.println("Generated fault:");
                System.err.println("  Fault code    = " + fault.getFaultCode());
                System.err.println("  Fault string  = " + fault.getFaultString());
                System.exit(0);
            }
        }
        catch (Exception exc)
        {
            exc.printStackTrace();
        }
    }
}

