package jwsunleashed.trading.ejb;

public class TradeResult implements java.io.Serializable
{
    public static final int PUT = 1;
    public static final int BUY = 2;
    public static final String[] TRADE_TYPES = { "", "PUT", "BUY" };

    public static final int TRADE_COMPLETED = 1;
    public static final int TRADE_PENDING = 2;
    public static final int TRADE_RETRACTED = 3;
    public static final int NO_PUT_FOUND = 4;
    public static final int NO_BUY_FOUND = 5;

    public static final String[] STATUSES = {
        "", "TRADE COMPLETED", "TRADE PENDING", "TRADE RETRACTED",
        "NO PUT FOUND", "NO BUY FOUND" };

    public int status;
    public int tradeID;
    public int sellerID;
    public int buyerID;
    public int putID;
    public int buyID;

    public int tradeType;
    public String stock;
    public int price;
    public int shares;
    
    public TradeResult()
    {
    }

    public int getStatus() { return status; }
    public void setStatus(int aStatus) { status = aStatus; }

    public int getTradeID() { return tradeID; }
    public void setTradeID(int aTradeID) { tradeID = aTradeID; }

    public int getSellerID() { return sellerID; }
    public void setSellerID(int aSellerID) { sellerID = aSellerID; }

    public int getBuyerID() { return buyerID; }
    public void setBuyerID(int aBuyerID) { buyerID = aBuyerID; }

    public int getBuyID() { return buyID; }
    public void setBuyID(int aBuyID) { buyID = aBuyID; }

    public int getPutID() { return putID; }
    public void setPutID(int aPutID) { putID = aPutID; }

    public int getTradeType() { return tradeType; }
    public void setTradeType(int aTradeType) { tradeType = aTradeType; }

    public String getStock() { return stock; }
    public void setStock(String aStock) { stock = aStock; }

    public int getPrice() { return price; }
    public void setPrice(int aPrice) { price = aPrice; }

    public int getShares() { return shares; }
    public void setShares(int aShares) { shares = aShares; }

    public String toString()
    {
        StringBuffer out = new StringBuffer();
        out.append("Status: ");
        out.append(STATUSES[status]);
        if (tradeID > 0)
        {
            out.append(", Trade: ");
            out.append(tradeID);
        }
        if (buyerID > 0)
        {
            out.append(", Buyer: ");
            out.append(buyerID);
        }
        if (sellerID > 0)
        {
            out.append(", Seller: ");
            out.append(sellerID);
        }
        if (buyID > 0)
        {
            out.append(", Buy: ");
            out.append(buyID);
        }
        if (putID > 0)
        {
            out.append(", Put: ");
            out.append(putID);
        }
        if (tradeType > 0)
        {
            out.append(", Trade Type: ");
            out.append(TRADE_TYPES[tradeType]);
        }
        if (stock != null)
        {
            out.append(", Stock: ");
            out.append(stock);
            out.append(", Shares: ");
            out.append(shares);
            out.append(", Price: ");
            out.append(price);
        }

        return out.toString();
    }
}
