<%@page import="java.sql.*,java.net.*"%>
<%@page import="org.apache.soap.transport.*"%>
<%@page import="org.apache.soap.messaging.*"%>
<%@page import="org.apache.soap.*,org.apache.soap.encoding.*"%>
<%@page import="org.apache.soap.rpc.*,org.apache.soap.util.xml.*"%>
<%@page import="org.apache.soap.encoding.soapenc.*"%>
<%!
private String manufacturer = null,
               productNumber = null,
               description = null;
private int stockLevel = 0;
private boolean getLocalStockLevel(String productid)
   throws SQLException
{
    boolean result = false;
    new org.hsqldb.jdbcDriver();
    Connection connection =
        DriverManager.getConnection("jdbc:hsqldb:db/reseller",
                                    "sa",
                                    null);
    try {
        PreparedStatement stmt = connection.prepareStatement(
            "select description, manufacturer, product_number, " +
            "stock_level from product where id = ?");
        try {
            stmt.setString(1,productid);
            ResultSet rs = stmt.executeQuery();
            try {
                if(rs.next()) {
                    description = rs.getString(1);
                    manufacturer = rs.getString(2);
                    productNumber = rs.getString(3);
                    stockLevel = rs.getInt(4);
                    result = true;
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
    }
    finally {
        connection.close();
    }
    return result;
}
%>
<%
String productId = request.getParameter("productid"),
       availability = "on special order",
       stRpcRouter = request.getParameter("rpcrouter"),
       stQty = request.getParameter("qty");
URL rpcRouter = new URL(stRpcRouter);
int qty = Integer.parseInt(stQty);
if(getLocalStockLevel(productId)) {
    int missing = qty - stockLevel;
    if(missing > 0) {
        Vector params = new Vector();
        Parameter p = new Parameter("manufacturer",
                                    String.class,
                                    manufacturer,
                                    null);
        params.addElement(p);
        p = new Parameter("sku",
                          String.class,
                          productNumber,
                          null);
        params.addElement(p);
        p = new Parameter("quantity",
                          Integer.class,
                          new Integer(missing),
                          null);
        params.addElement(p);
        Call call = new Call();
        call.setTargetObjectURI("http://www.psol.com/2001/inventory");
        call.setEncodingStyleURI(Constants.NS_URI_SOAP_ENC);
        call.setMethodName("canShipToday");
        call.setParams(params);
        Response rsp = call.invoke(rpcRouter,
                               "http://www.psol.com/2001/soapaction");
        if(!rsp.generatedFault()) {
            Boolean b =
                (Boolean)rsp.getReturnValue().getValue();
            if(b.booleanValue())
                availability = "within 2-4 days";
        }
    }
    else
       availability = "immediately";
}
%>
<html>
<head><title>Intranet Shop</title></head>
<body>
<h1>Intranet Shop</h1>
<%
if(availability != null) {
%>
<p><%= qty %> * <%= description %> ships <%= availability %>.</p>
<%
}
else {
%>
<p>Error: cannot determine the availability.</p>
<%
}
%>
<form action="index.jsp" method="post">
<input type="hidden" name="rpcrouter"
   value="<%= rpcRouter.toExternalForm() %>">
<input type="submit" value="Return to main page">
</form>
</body>
</html>
