package com.psol.inventory;

import java.sql.*;

public class InventoryService
{
    public InventoryService()
    {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch(ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public boolean canShipToday(String manufacturer,
                                String sku,
                                int quantity)
        throws SQLException
    {
        boolean result = false;
        Connection connection =
            DriverManager.getConnection("jdbc:hsqldb:db/wholesaler",
                                        "sa",
                                        null);
        try {
            PreparedStatement stmt =
                connection.prepareStatement("select level from" +
                    " inventory where manufacturer=? and sku=?");
            try {
                stmt.setString(1,manufacturer);
                stmt.setString(2,sku);
                ResultSet rs = stmt.executeQuery();
                try {
                    if(rs.next())
                        result = rs.getInt(1) > quantity;
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            connection.close();
        }
        return result;
    }
}
