package com.sams.jws.chapter18;

import com.ibm.wsif.WSIFDynamicPortFactory;
import com.ibm.wsif.WSIFPort;
import com.ibm.wsif.WSIFPart;
import com.ibm.wsif.WSIFJavaPart;
import com.ibm.wsif.WSIFMessage;
import com.ibm.wsif.stub.WSIFUtils;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.wsdl.PortType;

/**
 * WsifTimeServerClient
 * Prosta demonstracje podstawowej funkcjonalnoci WSIF.
 */

public class WsifTimeServerClient {

    public static void main(String[] args) throws Exception {

        String operationName = null;
        String zoneName = null;
        if (args.length == 1) {
            operationName = "synchronizeTime";
        } else if (args.length == 2) {
            operationName = "getTimeAtCity";
            zoneName = args[1];
        } else {
            String className = WsifTimeServerClient.class.getName();
System.err.println("Skadnie: java " + className + " [zoneName]");
            System.err.println(
                "Np: java "
                    + className
                    + "\t- zwraca czas systemowy serwera w postaci liczby (typu long) "
                    + "milisekund od pocztku epoki");
            System.err.println(
                "    java "
                    + className
                    + " America/Vancouver \t- zwraca w postaci cigu znakw biecy " 
                  + "czas i dat w Vancouver w odniesieniu do czasu serwera");
            System.exit(0);
        }
        String portName = args[0];

        System.out.println("Wczytywanie dokumentu WSDL");
        Definition definition =
            WSIFUtils.readWSDL(null, "http://localhost:8080/wsif/TimeServer.wsdl");

        Service service =
            WSIFUtils.selectService(
                definition,
                "http://localhost:8080/wsif/TimeServer",
                "TimeService");
        PortType portType =
            WSIFUtils.selectPortType(
                definition,
                "http://localhost:8080/wsif/TimeServer-interface",
                "TimeServicePortType");
        WSIFDynamicPortFactory wsifDynPortFac =
            new WSIFDynamicPortFactory(definition, service, portType);
        System.out.println("Retrieving WSIFPort");
        WSIFPort wsifPort = wsifDynPortFac.getPort(portName);

        WSIFMessage inputWsifMsg = wsifPort.createInputMessage();
        WSIFMessage outputWsifMsg = wsifPort.createOutputMessage();
        WSIFMessage faultWsifMsg = wsifPort.createFaultMessage();

        // Argument wejciowy dla getTimeAtCity
        if (operationName.equals("getTimeAtCity")) {
            WSIFPart inputWsifPart = new WSIFJavaPart(String.class, zoneName);
            WSIFPart inputWsifPart2 = new WSIFJavaPart(java.lang.Integer.class, new Integer(123));
            inputWsifMsg.setPart("zoneName", inputWsifPart);
        }

        // Wykonanie dania
        wsifPort.executeRequestResponseOperation(
            operationName,
            inputWsifMsg,
            outputWsifMsg,
            faultWsifMsg);

        // Obsuga zwracanych wartoci
        WSIFPart outputWsifPart = outputWsifMsg.getPart("return");
        System.out.println(
            "Return value for "
                + operationName
                + "() is: "
                + outputWsifPart.getJavaValue());

        System.out.println("Gotowe.");
    }
}
