package com.sams.jws.chapter18;
import java.util.Vector;
import java.net.URL;
import org.apache.soap.Constants;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;

public class TimeServerClient {
    public static void main(String[] args) throws Exception {
        URL url = new URL("http://localhost:8080/soap/servlet/rpcrouter");
        String operationName = null;
        if (args.length == 0) {
            operationName = "synchronizeTime";
        } else if (args.length == 1) {
            operationName = "getTimeAtCity";
        } else {
            String className = TimeServerClient.class.getName();
            System.err.println("Skadnie: java " + className + " [zoneName]");
            System.err.println(
                "Np: java "
                    + className
                    + "\t- zwraca czas systemowy serwera w postaci liczby (typu long) "
                    + "milisekund od pocztku epoki");
            System.err.println(
                "    java "
                    + className
                    + " America/Vancouver \t- zwraca w postaci cigu znakw biecy " 
                  + "czas i dat w Vancouver w odniesieniu do czasu serwera");
            System.exit(0);
        }

        String encodingStyleURI = Constants.NS_URI_SOAP_ENC;

        // Tworzenie oglnego wywoania.
        Call call = new Call();
        call.setTargetObjectURI("urn:TimeServer");
        call.setEncodingStyleURI(encodingStyleURI);

        // Ustawianie parametru wejciowego dla getTimeAtCity
        if (operationName.equals("getTimeAtCity")) {
            String zoneName = args[0];
            Vector parameters = new Vector();
            parameters.addElement(new Parameter("zoneName", String.class, zoneName, null));
            call.setParams(parameters);
        }
        // Tworzenie i wykonanie wywoania metody synchronizeTime()
        call.setMethodName(operationName);

        Response response;
        try {
            response = call.invoke(url, "");
        } catch (SOAPException e) {
            System.err.println("Caught SOAPException:");
            e.printStackTrace();
            return;
        }

        // Sprawdzenie odpowiedzi.
        if (!response.generatedFault()) {
            Parameter returnParam = response.getReturnValue();
            Object value = returnParam.getValue();
            System.out.println("Warto zwracana przez " + operationName + "() to: " + value);

        } else {
            Fault fault = response.getFault();

            System.err.println("Wystpi bd: ");
            System.err.println("Kod:" + fault.getFaultCode());
            System.err.println("Opis bdu: " + fault.getFaultString());
        }
        System.out.println("Gotowe.");
    } // main()
} // Class TimeServerClient
